/*

 Security Software Testing Suite - Yalta (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * The original idea by Soft4Ever, http://www.soft4ever.com/.


 Method description:

   * Simply try to access the Internet using UDP protocol. This test was created
     in stone age of security software era and simply tests whether the tested
     system implements control of outbound UDP packets.

*/

#include <stdio.h>
#include <windows.h>
#include <winsock.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("Yalta","yalta",argc,argv,&conf,COM_TEST_TYPE_YALTA)) return 1;

  char *used_dlls[]={"ws2_32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  int res=FALSE;

  char ip_str[32];
  lstrcpynA(ip_str,inet_ntoa(conf.ip),sizeof(ip_str));

  WSADATA wsadata;
  int err=WSAStartup(MAKEWORD(1,1),&wsadata);
  if (!err)
  {
    if (com_verbosity_get()) printf("Creating UDP socket ...\n");

    SOCKET s=socket(AF_INET,SOCK_DGRAM,IPPROTO_UDP);
    if (s!=INVALID_SOCKET)
    {
      if (com_verbosity_get()) printf("Socket 0x%X created.\n",s);

      SOCKADDR_IN sa;
      sa.sin_family=AF_INET;
      sa.sin_addr.s_addr=conf.ip.s_addr;
      sa.sin_port=htons((WORD)conf.port);

      printf("Sending message to %s:%d (UDP).\n"
             "If your security software alerts you about this attempt, deny it!\n\n",ip_str,conf.port);

      if (sendto(s,conf.data64,strlen(conf.data64),0,(struct sockaddr *)&sa,sizeof(sa))!=SOCKET_ERROR)
      {
        if (com_verbosity_get()) printf("Message sent.\nReceiving answer ...\n");

        char buf[4096];

        int totlen=0;
        int ret=1;
        while (totlen<sizeof(buf) && (ret!=SOCKET_ERROR) && (ret!=0))
        {
          int timeout=5000;
          unsigned long pending=0;
          ret=ioctlsocket(s,FIONREAD,&pending);
          if (ret!=SOCKET_ERROR)
          {
            if (pending==0)
            {
              fd_set rset;
              FD_ZERO(&rset);
              FD_SET(s,&rset);
              struct timeval tv={timeout/1000,1000*(timeout%1000)};

              ret=select(1,&rset,NULL,NULL,&tv);
              if (ret==SOCKET_ERROR) com_err_set_nc(&err_inf,"Unable to wait for data from %s:%d.\n",ip_str,conf.port);
            }

            if ((ret!=0) && (ret!=SOCKET_ERROR))
            {
              SOCKADDR_IN peer;
              size_t peer_len=sizeof(peer);

              ret=recvfrom(s,&buf[totlen],sizeof(buf)-totlen,0,(struct sockaddr *)&peer,&peer_len);
              if (ret==SOCKET_ERROR) com_err_set_nc(&err_inf,"Unable to receive data from %s:%d.\n",ip_str,conf.port);
              else totlen+=ret;
            }
          } else com_err_set_nc(&err_inf,"Unable to get information from socket 0x%X.\n",s);
        }

        if (ret!=SOCKET_ERROR) res=com_find_pattern_and_print_data(buf,sizeof(buf),&conf,&err_inf);
      } else com_err_set(&err_inf,"Unable to send data to %s:%d (UDP).\n",ip_str,conf.port);

      closesocket(s);
    } else com_err_set(&err_inf,"Unable to create socket.\n");

    WSACleanup();
  } else com_err_set_sc(&err_inf,err,"Unable to initialize Windows Sockets.\n");

  return com_end(res,&err_inf,&conf);
}
