/*

 Security Software Testing Suite - Suspend1 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by Advanced Process Termination - Suspend 1, written by Diamond Computer Systems,
     http://www.diamondcs.com.au/.


 Method description:

   * Obtain the Debug privilege.

   * Open some thread of the target process and use SuspendThread API to suspend it. Repeat this step for every thread
     of the target process.

   * This test works with a list of processes and reports success if at least one thread of at least on process was suspended.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Suspend1","Suspend1",argc,argv,&conf,COM_TEST_TYPE_SUSPEND1)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);


  ULONG pids[conf.processes_cnt];
  int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
  if (ret)
  {
    for (int i=0;i<conf.processes_cnt;i++)
    {
      ULONG pid=pids[i];

      if (pid!=COM_CID_INVALID)
      {
        ULONG tids[256];
        int tids_cnt=256;
        if (com_get_tids_from_pid(pid,tids,&tids_cnt,&err_inf))
        {
          if (com_verbosity_get()) printf("%d thread(s) found in process \"%s\" (PID %ld).\n",tids_cnt,conf.processes[i],pid);

          for (int j=0;j<tids_cnt;j++)
          {
            HANDLE thread=NULL;
            if (com_thread_open(tids[j],THREAD_SUSPEND_RESUME,TRUE,TRUE,&thread,&err_inf))
            {
              DWORD sret=SuspendThread(thread);
              if (sret!=-1)
              {
                printf("Thread TID %ld (PID %ld, process name \"%s\") suspended.\n",tids[j],pid,conf.processes[i]);
                res=TRUE;
              } else com_err_set_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX,"Unable to suspend thread TID %ld (PID %ld, process name \"%s\").\n",
                                             tids[j],pid,conf.processes[i]);
              CloseHandle(thread);
            } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);
          }
        } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

        if (com_verbosity_get()) printf("\n");
      } else if (ret) fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);
    }
  }

  return com_end(res,&err_inf,&conf);
}
