/*

 Security Software Testing Suite - SockSnif (spying test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * The original idea by www.matousec.com, Different Internet Experience Ltd.


  Method description:

   * Create a raw socket.

   * Bind the raw socket with a local interface.

   * Enable promiscuous mode on the binded interface the socket to receive all ip packets.

   * Receive packets transmited over the interface and try to find the given pattern in TCP packets.

*/

#include <stdio.h>
#include <windows.h>
#include <winsock2.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "include/common-spy.h"
#include "include/tcpip.h"



SOCKET sock=INVALID_SOCKET;

int sniffing_thread_routine(PCOM_SPY_DATA kd)
{
  size_t magic_len=strlen(kd->conf->magic);

  int done=FALSE;
  while (!done)
  {
    DWORD wres=WaitForSingleObject(kd->event,10);
    switch (wres)
    {
      case WAIT_TIMEOUT:
      {
        int timeout=50;
        unsigned long pending=0;
        int ret=ioctlsocket(sock,FIONREAD,&pending);
        if (ret!=SOCKET_ERROR)
        {
          ret=1;
          if (pending==0)
          {
            fd_set rset;
            FD_ZERO(&rset);
            FD_SET(sock,&rset);
            struct timeval tv={timeout/1000,1000*(timeout%1000)};

            ret=select(1,&rset,NULL,NULL,&tv);
            if (ret==SOCKET_ERROR)
            {
              com_err_set(kd->err_inf,"Unable to wait for events on socket 0x%X.\n",sock);
              done=TRUE;
            }
          }

          if (ret!=0)
          {
            char buf[COM_INET_IP_MAX_LEN];
            memset(buf,0,sizeof(buf));

            size_t received=0;
            received=recv(sock,buf,sizeof(buf),0);
            if ((received!=SOCKET_ERROR) && (received!=0))
            {
              PIP_HEADER ipheader=(PIP_HEADER)buf;

              if (ipheader->ip_protocol==IPPROTO_TCP)
              {
                size_t ipheader_size=ipheader->ip_header_len*4;
                PTCP_HEADER tcpheader=(PTCP_HEADER)(buf+ipheader_size);
                size_t tcpheader_size=tcpheader->data_offset*4;

                char *payload=buf+ipheader_size+tcpheader_size;
                size_t payload_size=received-ipheader_size-tcpheader_size;

                char *pl_it=payload;
                size_t pl_sz=payload_size;

                int found=FALSE;
                while ((!found) && (magic_len<pl_sz))
                {
                  if (!strnicmp(pl_it,kd->conf->magic,magic_len))
                  {
                    found=TRUE;
                  } else
                  {
                    pl_sz--;
                    pl_it++;
                  }
                }

                if (found)
                {
                  struct in_addr addr_src={.S_un.S_addr=ipheader->ip_srcaddr};
                  struct in_addr addr_dst={.S_un.S_addr=ipheader->ip_destaddr};
                  char addr_str_src[32],addr_str_dst[32];
                  lstrcpynA(addr_str_src,inet_ntoa(addr_src),sizeof(addr_str_src));
                  lstrcpynA(addr_str_dst,inet_ntoa(addr_dst),sizeof(addr_str_dst));
                  printf("\nPattern found in TCP packet from %s:%d to %s:%d:\n\n----\n",addr_str_src,tcpheader->source_port,
                         addr_str_dst,tcpheader->dest_port);

                  // print bytes around the pattern
                  char *data=payload;
                  if (pl_it-payload>0x40) data=pl_it-0x40;
                  size_t data_size=0x80;
                  if ((pl_it-0x40+data_size)>(payload+payload_size)) data_size=payload+payload_size-pl_it+0x40;

                  for (int i=0;i<data_size;i++)
                  {
                    if (*data<' ') printf(".");
                    else printf("%c",*data);
                    if (((i+1)%0x20)==0) printf("\n");
                    data++;
                  }
                  printf("----\n\n");

                  kd->res=TRUE;
                  done=TRUE;
                  if (!SetEvent(kd->event)) com_err_set(kd->err_inf,"Unable to signal event.\n");
                }
              }
            } else if (received==SOCKET_ERROR)
            {
              com_err_set(kd->err_inf,"Unable to receive data from raw socket.\n");
              done=TRUE;
            } else if (received==0)
            {
              com_err_set(kd->err_inf,"Unable to receive data anymore. Socket has been closed.\n");
              done=TRUE;
            }
          }
        } else
        {
          com_err_set(kd->err_inf,"Unable to get status information of socket 0x%X.\n",sock);
          done=TRUE;
        }

        break;
      }

      case WAIT_OBJECT_0:
        done=TRUE;
        break;

      default:
        if (wres!=WAIT_FAILED) SetLastError(ERROR_SUCCESS);
        com_err_set(kd->err_inf,"Unknown error occurred, WaitForSingleObject returned %ld.\n",wres);

        done=TRUE;
        break;
    }
  }

  return kd->res;
}

int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("SockSnif","socksnif",argc,argv,&conf,COM_TEST_TYPE_SOCKSNIF)) return 1;

  char *used_dlls[]={"ws2_32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  int res=FALSE;

  char ip_str[32];
  lstrcpynA(ip_str,inet_ntoa(conf.ip),sizeof(ip_str));

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_SPY_DATA kd;
  if (com_spy_data_init(&kd,&conf,&err_inf))
  {
    WSADATA wsadata;
    int ret=WSAStartup(MAKEWORD(1,1),&wsadata);
    if (ret==0)
    {
      if (com_verbosity_get()) printf("Windows sockets initialized.\n");

      sock=socket(AF_INET,SOCK_RAW,IPPROTO_IP);
      if (sock!=INVALID_SOCKET)
      {
        if (com_verbosity_get()) printf("RAW socket created.\n");

        struct sockaddr_in dest;
        memset(&dest,0,sizeof(dest));

        dest.sin_addr.s_addr=conf.ip.s_addr;
        dest.sin_family=AF_INET;
        dest.sin_port=0;

        if (!bind(sock,(SOCKADDR *)&dest,sizeof(dest)))
        {
          if (com_verbosity_get()) printf("Socket binded with %s.\n",ip_str);

          u_long set=RCVALL_ON;
          ret=ioctlsocket(sock,SIO_RCVALL,&set);
          if (ret!=SOCKET_ERROR)
          {
            if (com_verbosity_get()) printf("Promiscuous mode on socket binded to %s interface enabled.\n",ip_str);

            HANDLE thread=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)sniffing_thread_routine,&kd,0,NULL);
            if (thread)
            {
              if (com_verbosity_get()) printf("Sniffing thread started.\n");

              printf("Press any key to exit.\n");

              com_spy_wait(&kd,thread);

              CloseHandle(thread);
            } else com_err_set(&err_inf,"Unable to create thread.\n");

            res=kd.res;
            com_spy_data_finit(&kd);
          } else com_err_set(&err_inf,"Unable to enable promiscuous mode on socket binded to %s interface.\n",ip_str);
        } else com_err_set(&err_inf,"Unable to bind socket with %s.\n",ip_str);

        closesocket(sock);
      } else com_err_set(&err_inf,"Unable to create socket.\n");

      WSACleanup();
    } else com_err_set_sc(&err_inf,ret,"Unable to initialize Windows Sockets.\n");
  }

  return com_end(res,&err_inf,&conf);
}
