/*

 Security Software Testing Suite - Kill9 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is also used by Simple Process Termination - Method 7, written by System Safety Limited.


 Method description:

   * Obtain the Debug privilege.

   * Create a job object.

   * Open the target process and assign it to the job object.

   * Use TerminateJobObject API to kill the target process.

   * This test works with a list of processes and reports success if at least one process was terminated.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Kill9","kill9",argc,argv,&conf,COM_TEST_TYPE_KILL9)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);


  ULONG pids[conf.processes_cnt];
  int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
  if (ret)
  {
    for (int i=0;i<conf.processes_cnt;i++)
    {
      ULONG pid=pids[i];

      if (pid!=COM_CID_INVALID)
      {
        if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pid);

        HANDLE job=CreateJobObject(NULL,NULL);
        if (job)
        {
          HANDLE proc=NULL;
          if (com_process_open(pid,PROCESS_SET_QUOTA | PROCESS_TERMINATE,TRUE,TRUE,&proc,&err_inf))
          {
            if (AssignProcessToJobObject(job,proc))
            {
              if (com_verbosity_get()) printf("Process \"%s\" (PID %ld) assigned to the job.\n",conf.processes[i],pid);
              if (TerminateJobObject(job,0))
              {
                printf("Process \"%s\" (PID %ld) terminated with the job object.\n",conf.processes[i],pid);
                res=TRUE;
              } else com_err_set_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX,"Unable to terminate job object with process \"%s\" (PID %ld).\n",conf.processes[i],pid);
            } else com_err_set_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX,"Unable to assign process \"%s\" (PID %ld) to the job.\n",conf.processes[i],pid);

            CloseHandle(proc);
          } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

          if (com_verbosity_get()) printf("\n");
          CloseHandle(job);
        } else
        {
          com_err_set(&err_inf,"Unable to create a job object.\n");
          break;
        }
      } else if (ret) fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);
    }

    res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);
  }

  return com_end(res,&err_inf,&conf);
}
