/*

 Security Software Testing Suite - Kill1 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by Advanced Process Termination - Kill 1, written by Diamond Computer Systems,
     formerly (http://www.diamondcs.com.au/).

   * This technique is also used by Simple Process Termination - Method 1, written by System Safety Limited.

   * This technique is also used by ProcX - Normal method, written by Guillaume Kaddouch, http://www.firewallleaktester.com/.


 Method description:

   * Obtain the Debug privilege.

   * Open the target process and use TerminateProcess API to kill it.

   * This test works with a list of processes and reports success if at least one process was terminated.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Kill1","kill1",argc,argv,&conf,COM_TEST_TYPE_KILL1)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);


  ULONG pids[conf.processes_cnt];
  int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
  if (ret)
  {
    for (int i=0;i<conf.processes_cnt;i++)
    {
      ULONG pid=pids[i];

      if (pid!=COM_CID_INVALID)
      {
        if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pid);

        HANDLE proc=NULL;
        if (com_process_open(pid,PROCESS_TERMINATE,TRUE,TRUE,&proc,&err_inf))
        {
          if (TerminateProcess(proc,0)) printf("Process \"%s\" (PID %ld) terminated.\n",conf.processes[i],pid);
          else com_err_set_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX,"Unable to terminate process \"%s\" (PID %ld).\n",
                                       conf.processes[i],pid);

          CloseHandle(proc);
        } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

        if (com_verbosity_get()) printf("\n");
      } else fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);
    }

    res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);
  }

  return com_end(res,&err_inf,&conf);
}
