/*

 TCP/IP and sockets support header for Security Software Testing Suite
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#ifndef __TCPIP_H__
#define __TCPIP_H__

#include <winsock2.h>

// missing defines
#define SIO_RCVALL      _WSAIOW(IOC_VENDOR,1)

#define RCVALL_OFF              0
#define RCVALL_ON               1
#define RCVALL_SOCKETLEVELONLY  2


//IP Header Structure
typedef struct IP_HEADER
{
  unsigned char ip_header_len:4;
  unsigned char ip_version:4;
  unsigned char ip_tos;
  unsigned short ip_total_length;
  unsigned short ip_id;

  unsigned char ip_frag_offset:5;

  unsigned char ip_more_fragment:1;
  unsigned char ip_dont_fragment:1;
  unsigned char ip_reserved_zero:1;

  unsigned char ip_frag_offset1;

  unsigned char ip_ttl;
  unsigned char ip_protocol;
  unsigned short ip_checksum;
  unsigned int ip_srcaddr;
  unsigned int ip_destaddr;
} IP_HEADER,*PIP_HEADER;

// TCP Header Structure
typedef struct TCP_HEADER
{
  unsigned short source_port;
  unsigned short dest_port;
  unsigned int sequence;
  unsigned int acknowledge;

  unsigned char ns:1;
  unsigned char reserved_part1:3;
  unsigned char data_offset:4;
  unsigned char fin:1;
  unsigned char syn:1;
  unsigned char rst:1;
  unsigned char psh:1;
  unsigned char ack:1;
  unsigned char urg:1;

  unsigned char ecn:1;
  unsigned char cwr:1;

  unsigned short window;
  unsigned short checksum;
  unsigned short urgent_pointer;
} TCP_HEADER,*PTCP_HEADER;


#endif
