/*

 DNS support header for Security Software Testing Suite
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the code by Jarkko Turkulainen, http://www.klake.org/~jt/dnshell/.

*/

#ifndef __DNS_H__
#define __DNS_H__

// DNS server port
#define DNS_SERVER_PORT_UDP     53

// DNS_SECTION_HEADER.flags values
#define DNS_SH_QR_SET           1 << 15
#define DNS_SH_OPCODE_IQUERY    1 << 12
#define DNS_SH_OPCODE_STATUS    1 << 11
#define DNS_SH_AA_SET           1 << 10
#define DNS_SH_TC_SET           1 << 9
#define DNS_SH_RD_SET           1 << 8
#define DNS_SH_RA_SET           1 << 7

// DNS_SECTION_HEADER.qr values
#define DNS_QR_QUERY            0
#define DNS_QR_RESPONSE         1

// DNS_SECTION_HEADER.opcode values
#define DNS_OPCODE_STANDARD     0
#define DNS_OPCODE_INVERSE      1
#define DNS_OPCODE_SRV_STATUS   2

// DNS_SECTION_HEADER.rcode values
#define DNS_RCODE(f)            (ntohs(f)&0x0F)
#define DNS_RCODE_NO_ERROR      0
#define DNS_RCODE_FORMAT_ERROR  1
#define DNS_RCODE_SRV_FAILURE   2
#define DNS_RCODE_NAME_ERROR    3
#define DNS_RCODE_NOT_IMPLEMENTED 4
#define DNS_RCODE_REFUSED       5

// DNS_SECTION_QUESTION_TAIL.qtype values
#define DNS_QCTYPE_A            1       // host address
#define DNS_QCTYPE_NS           2       // authoritative name server
#define DNS_QCTYPE_MD           3       // mail destination
#define DNS_QCTYPE_MF           4       // mail forwarder
#define DNS_QCTYPE_CNAME        5       // canonical name for an alias
#define DNS_QCTYPE_SOA          6       // marks the start of a zone of authority
#define DNS_QCTYPE_MB           7       // mailbox domain name
#define DNS_QCTYPE_MG           8       // mail group member
#define DNS_QCTYPE_MR           9       // mail rename domain name
#define DNS_QCTYPE_NULL         10      // null RR
#define DNS_QCTYPE_WKS          11      // well known service description
#define DNS_QCTYPE_PTR          12      // domain name pointer
#define DNS_QCTYPE_HINFO        13      // host information
#define DNS_QCTYPE_MINFO        14      // mailbox or mail list information
#define DNS_QCTYPE_MX           15      // mail exchange
#define DNS_QCTYPE_TXT          16      // text strings

// DNS_SECTION_QUESTION_TAIL.qclass values
#define DNS_QCLASS_IN           1
#define DNS_QCLASS_CS           2
#define DNS_QCLASS_CH           3
#define DNS_QCLASS_HS           4
#define DNS_QCLASS_ANY          255

// registry path to network interfaces
#define REG_INTERFACES          "SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters\\Interfaces"

// http://www.ietf.org/rfc/rfc1035.txt - 4.1.1. Header section format
typedef struct DNS_SECTION_HEADER
{
  WORD id;                      // user defined message identifier
  WORD flags;                   // various flags and values (see RFC) - set via DNS_SH_*
  WORD qdcount;                 // number of entries in question section
  WORD ancount;                 // number of entries in answer section
  WORD nscount;                 // number of entries in authority records section
  WORD arcount;                 // number of entries in additional records section
} DNS_SECTION_HEADER,*PDNS_SECTION_HEADER;

typedef struct DNS_SECTION_QUESTION_TAIL
{
  WORD qtype;                   // question type DNS_QCTYPE_*
  WORD qclass;                  // question class - 1 = Internet, 2 = CSNET, 3 = CHAOS, 4 = Hesoid
} DNS_SECTION_QUESTION_TAIL,*PDNS_SECTION_QUESTION_TAIL;

#endif
