/*

 Header file for Security Software Testing Suite - Shared code library
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#ifndef __LP_COMMON_H__
#define __LP_COMMON_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <windows.h>
#include <winsock.h>
#include <aclapi.h>
#include "ntinternals.h"

// mapping and event name prefixes and suffixes and length limits
#define COM_EVENT_PREFIX        "ssts_"
#define COM_EVENT_SUFFIX        "_evt"
#define COM_EVENT_NAME_MAX_LEN  32
#define COM_MAPPING_PREFIX      "ssts_"
#define COM_MAPPING_SUFFIX      "_map"
#define COM_MAPPING_NAME_MAX_LEN 32

// Internet agent name for InternetOpen call
#define COM_INET_AGENT          "Security Software Testing Suite"

// default data size limit
#define COM_MAP_DEFAULT_DATA_SIZE_MAX  0x4000
#define COM_MAP_DEFAULT_DATA_BUFFER_SIZE_MAX 0x2000

// default error message length limit
#define COM_MAP_DEFAULT_ERR_SIZE_MAX   2*MAX_PATH+512



// maximal lengths of configurable settings
#define COM_INET_URL_MAX_LEN    512
#define COM_INET_DELIM_MAX_LEN  16
#define COM_INET_DATA_MAX_LEN   1136
#define COM_INET_DATA64_MAX_LEN 1516
#define COM_INET_URI_MAX_LEN    COM_INET_URL_MAX_LEN+COM_INET_DELIM_MAX_LEN+COM_INET_DATA64_MAX_LEN
#define COM_INET_MAGIC_MAX_LEN  64
#define COM_INET_HOST_MAX_LEN   64

// maximal lengths of UDP packet data
#define COM_INET_UDP_MAX_LEN    65500
// maximal length of IP packet
#define COM_INET_IP_MAX_LEN     65535

// name of the config file
#define COM_CONFIG_FILE         "ssts.conf"
// maximum length of config file line
#define COM_CONFIG_FILE_MAX_LINE_LEN    256
// maximum number of processes, services and files
#define COM_CONFIG_FILE_MAX_PROCESSES   256
#define COM_CONFIG_FILE_MAX_SERVICES    256
#define COM_CONFIG_FILE_MAX_FILES       256


// parts of configuration file to be used by tests
#define COM_TEST_TYPE_USE_UNKNOWN       0
#define COM_TEST_TYPE_USE_URL           (1 << 0)
#define COM_TEST_TYPE_USE_DATA_DELIM    (1 << 1)
#define COM_TEST_TYPE_USE_DATA          (1 << 2)
#define COM_TEST_TYPE_USE_DATA46        (1 << 3)
#define COM_TEST_TYPE_USE_PATTERN_NET   (1 << 4)
#define COM_TEST_TYPE_USE_PATTERN_SNIFF (1 << 5)
#define COM_TEST_TYPE_USE_DOMAIN        (1 << 6)
#define COM_TEST_TYPE_USE_DOMAIN2ND     (1 << 7)
#define COM_TEST_TYPE_USE_IP_TCP        (1 << 8)
#define COM_TEST_TYPE_USE_IP_UDP        (1 << 9)
#define COM_TEST_TYPE_USE_IP_RAW        (1 << 10)
#define COM_TEST_TYPE_USE_IP_LOC        (1 << 11)
#define COM_TEST_TYPE_USE_PORT_TCP      (1 << 12)
#define COM_TEST_TYPE_USE_PORT_UDP      (1 << 13)
#define COM_TEST_TYPE_USE_PAGE          (1 << 14)
#define COM_TEST_TYPE_USE_PEER_IP_TCP   (1 << 15)
#define COM_TEST_TYPE_USE_PEER_IP_UDP   (1 << 16)
#define COM_TEST_TYPE_USE_PEER_PORT_TCP (1 << 17)
#define COM_TEST_TYPE_USE_PEER_PORT_UDP (1 << 18)
#define COM_TEST_TYPE_USE_PEER_BUF_SIZE_TCP (1 << 19)
#define COM_TEST_TYPE_USE_PEER_BUF_SIZE_UDP (1 << 20)
#define COM_TEST_TYPE_USE_PEER_BUF_CNT_TCP (1 << 21)
#define COM_TEST_TYPE_USE_PEER_BUF_CNT_UDP (1 << 22)
#define COM_TEST_TYPE_USE_PROCESS_LIST  (1 << 23)
#define COM_TEST_TYPE_USE_SERVICE_LIST  (1 << 24)
// special value for configuration file agreement
#define COM_TEST_TYPE_USE_AGREEMENT     ((unsigned int)-1)

// default configuration values
#define COM_CONF_DEF_URL           "http://www.matousec.com/projects/proactive-security-challenge/test.php"
#define COM_CONF_DEF_DATA_DELIM    "?"
#define COM_CONF_DEF_DATA          "I have failed the test"
#define COM_CONF_DEF_DATA46        "I have failed the test"
#define COM_CONF_DEF_PATTERN_NET   "YOUR SYSTEM FAILED THIS TEST"
#define COM_CONF_DEF_PATTERN_SNIFF "QWERTY"
#define COM_CONF_DEF_DOMAIN        "www.matousec.com"
#define COM_CONF_DEF_DOMAIN2ND     "matousec.com"
#define COM_CONF_DEF_IP_TCP        "89.185.231.11"
#define COM_CONF_DEF_IP_UDP        "192.168.1.1"
#define COM_CONF_DEF_IP_RAW        "89.185.231.11"
#define COM_CONF_DEF_IP_LOC        "192.168.1.1"
#define COM_CONF_DEF_PORT_TCP      80
#define COM_CONF_DEF_PORT_UDP      53
#define COM_CONF_DEF_PAGE          "/projects/proactive-security-challenge/test.php"
#define COM_CONF_DEF_PEER_IP_TCP   "192.168.1.1"
#define COM_CONF_DEF_PEER_IP_UDP   "192.168.1.1"
#define COM_CONF_DEF_PEER_PORT_TCP 2222
#define COM_CONF_DEF_PEER_PORT_UDP 2222
#define COM_CONF_DEF_PEER_BUF_SIZE_TCP 1048576
#define COM_CONF_DEF_PEER_BUF_SIZE_UDP 1400
#define COM_CONF_DEF_PEER_BUF_CNT_TCP 500
#define COM_CONF_DEF_PEER_BUF_CNT_UDP 200000


// types of tests
#define COM_TEST_TYPE_WININET  (COM_TEST_TYPE_USE_URL                   \
                              | COM_TEST_TYPE_USE_DATA_DELIM            \
                              | COM_TEST_TYPE_USE_DATA                  \
                              | COM_TEST_TYPE_USE_PATTERN_NET)

#define COM_TEST_TYPE_BITSTEST  COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_BREAKOUT1 COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_BREAKOUT2 COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_COAT      COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_CPIL      COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_CPILSUITE2 COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_CPILSUITE3 COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_DDETEST   COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_FIREHOLE  COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_FIREHOLE2 COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_FLANK     COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_GHOST     COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_JUMPER    COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_NEWCLASS  COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_OSFWBYPASS COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_RUNNER    COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_RUNNER2   COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_SCHEDTEST COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_SCHEDTEST2 COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_TOOLEAKY  COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_VBSTEST   COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_WALLBREAKER1 COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_WALLBREAKER3 COM_TEST_TYPE_WININET
#define COM_TEST_TYPE_WALLBREAKER4 COM_TEST_TYPE_WININET


#define COM_TEST_TYPE_WINSOCKT (COM_TEST_TYPE_USE_DOMAIN                \
                              | COM_TEST_TYPE_USE_IP_TCP                \
                              | COM_TEST_TYPE_USE_PORT_TCP              \
                              | COM_TEST_TYPE_USE_PAGE                  \
                              | COM_TEST_TYPE_USE_DATA_DELIM            \
                              | COM_TEST_TYPE_USE_DATA                  \
                              | COM_TEST_TYPE_USE_PATTERN_NET)

#define COM_TEST_TYPE_AWFT1     COM_TEST_TYPE_WINSOCKT
#define COM_TEST_TYPE_AWFT3     COM_TEST_TYPE_WINSOCKT
#define COM_TEST_TYPE_AWFT4     COM_TEST_TYPE_WINSOCKT
#define COM_TEST_TYPE_CPILSUITE1 COM_TEST_TYPE_WINSOCKT
#define COM_TEST_TYPE_COPYCAT   COM_TEST_TYPE_WINSOCKT
#define COM_TEST_TYPE_LEAKTEST  COM_TEST_TYPE_WINSOCKT
#define COM_TEST_TYPE_THERMITE  COM_TEST_TYPE_WINSOCKT


#define COM_TEST_TYPE_WINSOCKU (COM_TEST_TYPE_USE_IP_UDP                \
                              | COM_TEST_TYPE_USE_PORT_UDP              \
                              | COM_TEST_TYPE_USE_DATA                  \
                              | COM_TEST_TYPE_USE_PATTERN_NET)

#define COM_TEST_TYPE_YALTA     COM_TEST_TYPE_WINSOCKU


#define COM_TEST_TYPE_DATA46   (COM_TEST_TYPE_USE_DOMAIN2ND             \
                              | COM_TEST_TYPE_USE_DATA46)

#define COM_TEST_TYPE_DNSTEST   COM_TEST_TYPE_DATA46
#define COM_TEST_TYPE_DNSTESTER COM_TEST_TYPE_DATA46


#define COM_TEST_TYPE_RAW      (COM_TEST_TYPE_USE_IP_RAW                \
                              | COM_TEST_TYPE_USE_DATA                  \
                              | COM_TEST_TYPE_USE_PATTERN_NET)

#define COM_TEST_TYPE_ECHOTEST  COM_TEST_TYPE_RAW
#define COM_TEST_TYPE_ECHOTEST2 COM_TEST_TYPE_RAW


#define COM_TEST_TYPE_GENERAL  (COM_TEST_TYPE_USE_URL                   \
                              | COM_TEST_TYPE_USE_DATA_DELIM            \
                              | COM_TEST_TYPE_USE_DATA                  \
                              | COM_TEST_TYPE_USE_PATTERN_NET           \
                              | COM_TEST_TYPE_USE_PROCESS_LIST          \
                              | COM_TEST_TYPE_USE_SERVICE_LIST)

#define COM_TEST_TYPE_CRASH1    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_CRASH2    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_CRASH3    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_CRASH4    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_CRASH5    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_CRASH6    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_CRASH7    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KERNEL1   COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KERNEL1B  COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KERNEL2   COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KERNEL3   COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KERNEL4   COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KERNEL4B  COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KERNEL5   COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL1     COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL2     COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL3     COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL3B    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL3C    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL3D    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL3E    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL3F    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL4     COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL5     COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL6     COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL7     COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL8     COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL9     COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL10    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL11    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_KILL12    COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_SSS       COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_SSS2      COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_SSS3      COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_SSS4      COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_SUSPEND1  COM_TEST_TYPE_GENERAL
#define COM_TEST_TYPE_SUSPEND2  COM_TEST_TYPE_GENERAL


#define COM_TEST_TYPE_SPY      (COM_TEST_TYPE_USE_IP_LOC                \
                              | COM_TEST_TYPE_USE_PATTERN_SNIFF)

#define COM_TEST_TYPE_KEYLOG1   COM_TEST_TYPE_SPY
#define COM_TEST_TYPE_KEYLOG2   COM_TEST_TYPE_SPY
#define COM_TEST_TYPE_KEYLOG3   COM_TEST_TYPE_SPY
#define COM_TEST_TYPE_KEYLOG4   COM_TEST_TYPE_SPY
#define COM_TEST_TYPE_KEYLOG5   COM_TEST_TYPE_SPY
#define COM_TEST_TYPE_KEYLOG6   COM_TEST_TYPE_SPY
#define COM_TEST_TYPE_KEYLOG7   COM_TEST_TYPE_SPY
#define COM_TEST_TYPE_SOCKSNIF  COM_TEST_TYPE_SPY

#define COM_TEST_TYPE_NETWORKT (COM_TEST_TYPE_USE_PEER_IP_TCP           \
                              | COM_TEST_TYPE_USE_PEER_PORT_TCP         \
                              | COM_TEST_TYPE_USE_PEER_BUF_SIZE_TCP     \
                              | COM_TEST_TYPE_USE_PEER_BUF_CNT_TCP)

#define COM_TEST_TYPE_NETWORKU (COM_TEST_TYPE_USE_PEER_IP_UDP           \
                              | COM_TEST_TYPE_USE_PEER_PORT_UDP         \
                              | COM_TEST_TYPE_USE_PEER_BUF_SIZE_UDP     \
                              | COM_TEST_TYPE_USE_PEER_BUF_CNT_UDP)


// default browser's window title
#define COM_INET_BROWSER_TITLE  "about:blank";

// common final messages
#define COM_MSG_TEST_FAILED     "\nYOUR SYSTEM PASSED THE TEST!\n"
#define COM_MSG_TEST_SUCCEEDED  "\nYOUR SYSTEM FAILED THE TEST!\n"

// invalid process identifier
#define COM_CID_INVALID         ((ULONG)-1)

// com_hash_str() return value for "kernel32.dll" and similar strings
#define COM_HASH_KERNEL32_DLL           0x7F76DA18
#define COM_HASH_NTDLL_DLL              0xE2F10CC

// instructions opcodes for IA-32
#define COM_INSTR_IA32_CALL             0xE8
#define COM_INSTR_IA32_INT3             0xCC
#define COM_INSTR_IA32_NOP              0x90
#define COM_INSTR_IA32_PUSH             0x68
#define COM_INSTR_IA32_RET              0xC3

// standard error prefix
#define COM_ERR_STANDARD_PREFIX         "\nERROR: "

// handle of the current thread
#define COM_HANDLE_CURRENT_THREAD       ((HANDLE)-2)


// maximum length of service name
#define COM_MAX_SERVICE_NAME            256

/*
 Obtains a pointer to current process' Process Environment Block.

 Returns a pointer to Process Environment Block.
*/

#define com_get_peb()                           \
({                                              \
  PPEB peb=NULL;                                \
  __asm__                                       \
  (                                             \
    "mov eax,fs:[0x30]          \n"             \
    "mov [%0],eax               \n"             \
    : "+m" (peb)                                \
    :                                           \
  );                                            \
  peb;                                          \
})



/*
 Universal string hashing routine.

 'buf' Points to a buffer of chars or wide chars.
 'len' Size of 'buf' in bytes.

 Returns hash of 'len' characters in 'buf'.
*/

#define com_hash_str(buf,len)                   \
({                                              \
  size_t clen=len/sizeof(buf[0]);               \
  ULONG hash=clen;                              \
                                                \
  for (int i=0;i<clen;i++)                      \
  {                                             \
    hash*=i+2;                                  \
    hash+=(ULONG)buf[i] & ~('a'-'A');           \
  }                                             \
                                                \
  hash;                                         \
})



/*
 Obtains the image base of a loaded image identified by its hash.

 'hash' The hash of the image's name. Can be one of the predefined COM_HASH_*.

 Returns the image base of the module identified by 'hash'.
 If the module is not found the return value is NULL.
*/

#define com_get_base(hash)                      \
({                                              \
  PPEB xxx_peb=com_get_peb();                   \
  HMODULE xxx_base=NULL;                        \
                                                \
  PLDR_MODULE xxx_first_module=CONTAINING_RECORD(xxx_peb->LoaderData->InLoadOrderModuleList.Flink,LDR_MODULE,InLoadOrderModuleList); \
  PLDR_MODULE xxx_module=xxx_first_module;      \
  do                                            \
  {                                             \
    ULONG xxx_hash=com_hash_str(xxx_module->BaseDllName.Buffer,xxx_module->BaseDllName.Length); \
    if (xxx_hash==hash)                         \
    {                                           \
      xxx_base=xxx_module->BaseAddress;         \
      break;                                    \
    }                                           \
                                                \
    xxx_module=CONTAINING_RECORD(xxx_module->InLoadOrderModuleList.Flink,LDR_MODULE,InLoadOrderModuleList); \
  } while (xxx_module!=xxx_first_module);       \
                                                \
  xxx_base;                                     \
})



// information about on disk image
typedef struct COM_IMAGE_INFO
{
  PVOID image_base;                     // image base address
  DWORD image_size;                     // size of the image in memory
  PVOID entry_point;                    // image entry point
  WORD sub_system;                      // image subsystem IMAGE_SUBSYSTEM_*
} COM_IMAGE_INFO,*PCOM_IMAGE_INFO;

// common error information
typedef struct COM_ERROR
{
  int occurred;                         // TRUE if error occurred, FALSE otherwise
  DWORD code;                           // error code
  char msg[COM_MAP_DEFAULT_ERR_SIZE_MAX];  // null terminated error message
} COM_ERROR,*PCOM_ERROR;

// common client-to-server data
typedef struct COM_DATA
{
  COM_ERROR error;                      // error information
  char buffer[COM_MAP_DEFAULT_DATA_BUFFER_SIZE_MAX];   // message data
} COM_DATA,*PCOM_DATA;

// common mapping support data
typedef struct COM_MAPPING
{
  HANDLE event;                         // synchronization event handle
  HANDLE mapping;                       // mapping handle
  PCOM_DATA data;                       // pointer to mapping in the current process
} COM_MAPPING,*PCOM_MAPPING;

// common test configuration
typedef struct COM_CONF
{
  COM_MAPPING map;                      // mapping info

  struct in_addr ip;                    // target IPv4 address
  unsigned int port;                    // target TCP/UDP port
  unsigned int size;                    // packet or buffer size, integer aligned
  int count;                            // number of packets or buffers to transfer
  char host[COM_INET_HOST_MAX_LEN];     // target host name
  char url[COM_INET_URL_MAX_LEN];       // target URL
  char delim[COM_INET_DELIM_MAX_LEN];   // URL/data delimiter
  char data[COM_INET_DATA_MAX_LEN];     // data to be send
  char data64[COM_INET_DATA64_MAX_LEN]; // encoded to be send
  char magic[COM_INET_MAGIC_MAX_LEN];   // magic pattern
  char uri[COM_INET_URI_MAX_LEN];       // URL+delimiter+base64(data)

  int processes_cnt;                    // number of process names in 'processes' array
  int files_cnt;                        // number of file names in 'files' array
  int services_cnt;                     // number of service names in 'services' array
  char (*processes)[MAX_PATH];          // pointer to dynamically allocated array of process names
  char (*files)[MAX_PATH];              // pointer to dynamically allocated array of file names
  char (*services)[COM_MAX_SERVICE_NAME]; // pointer to dynamically allocated array of service names
} COM_CONF,*PCOM_CONF;


// configuration file variable names to variable types mapping
typedef struct COM_CONF_VAR_MAP_ITEM
{
  char *name;                           // name of the variable in configuration file
  unsigned int type;                    // variable's type - one of COM_TEST_TYPE_USE_*
} COM_CONF_VAR_MAP_ITEM,*PCOM_CONF_VAR_MAP_ITEM;

static const struct COM_CONF_VAR_MAP_ITEM com_conf_var_type_map[]=
{
  {"url",               COM_TEST_TYPE_USE_URL                   },
  {"data_delimiter",    COM_TEST_TYPE_USE_DATA_DELIM            },
  {"data",              COM_TEST_TYPE_USE_DATA                  },
  {"data46",            COM_TEST_TYPE_USE_DATA46                },
  {"pattern_net",       COM_TEST_TYPE_USE_PATTERN_NET           },
  {"pattern_sniff",     COM_TEST_TYPE_USE_PATTERN_SNIFF         },
  {"domain",            COM_TEST_TYPE_USE_DOMAIN                },
  {"domain2nd",         COM_TEST_TYPE_USE_DOMAIN2ND             },
  {"ip_tcp",            COM_TEST_TYPE_USE_IP_TCP                },
  {"ip_udp",            COM_TEST_TYPE_USE_IP_UDP                },
  {"ip_raw",            COM_TEST_TYPE_USE_IP_RAW                },
  {"ip_loc",            COM_TEST_TYPE_USE_IP_LOC                },
  {"port_tcp",          COM_TEST_TYPE_USE_PORT_TCP              },
  {"port_udp",          COM_TEST_TYPE_USE_PORT_UDP              },
  {"page",              COM_TEST_TYPE_USE_PAGE                  },
  {"peer_ip_tcp",       COM_TEST_TYPE_USE_PEER_IP_TCP           },
  {"peer_ip_udp",       COM_TEST_TYPE_USE_PEER_IP_UDP           },
  {"peer_port_tcp",     COM_TEST_TYPE_USE_PEER_PORT_TCP         },
  {"peer_port_udp",     COM_TEST_TYPE_USE_PEER_PORT_UDP         },
  {"peer_buf_size_tcp", COM_TEST_TYPE_USE_PEER_BUF_SIZE_TCP     },
  {"peer_buf_size_udp", COM_TEST_TYPE_USE_PEER_BUF_SIZE_UDP     },
  {"peer_buf_cnt_tcp",  COM_TEST_TYPE_USE_PEER_BUF_CNT_TCP      },
  {"peer_buf_cnt_udp",  COM_TEST_TYPE_USE_PEER_BUF_CNT_UDP      },
  {"processes",         COM_TEST_TYPE_USE_PROCESS_LIST          },
  {"services",          COM_TEST_TYPE_USE_SERVICE_LIST          },
  {"agreement",         COM_TEST_TYPE_USE_AGREEMENT             },
};

// number of items in com_conf_var_type_map_count list
#define com_conf_var_type_map_count (sizeof(com_conf_var_type_map)/sizeof(COM_CONF_VAR_MAP_ITEM))


int com_verbosity_get(void);
int com_unhook_get(void);
int com_console_init(char *name,char* file,char *line,PCOM_CONF conf,int type);
int com_console_init_winmain(char *name,char* file,char *line,PCOM_CONF conf,int type);
int com_console_init_winmain_gui(char *name,char* file,char *line,PCOM_CONF conf,int type);
int com_console_init_main(char *name,char* file,int argc,char **argv,PCOM_CONF conf,int type);
int com_console_init_main_no_about(char *name,char* file,int argc,char **argv,PCOM_CONF conf,int type);
int com_console_init_main_with_credits(char *name,char* file,int argc,char **argv,PCOM_CONF conf,int type,char *credits);
int com_target_info_load(char *name,PCOM_CONF conf,int type);

void com_about(char *name);
void com_usage(char *name);
void com_print_last_error(void);
int com_end_pref(int res,PCOM_ERROR err_inf,PCOM_CONF conf,char *prefix);
int com_end(int res,PCOM_ERROR err_inf,PCOM_CONF conf);

void com_err_set(PCOM_ERROR err_inf,const char *format,...) __attribute__((format(__printf__,2,3)));
void com_err_set_nc(PCOM_ERROR err_inf,const char *format,...) __attribute__((format(__printf__,2,3)));
void com_err_set_sc(PCOM_ERROR err_inf,DWORD code,const char *format,...) __attribute__((format(__printf__,3,4)));
void com_err_print(PCOM_ERROR err_inf,char *prefix);
void com_err_print_clear(PCOM_ERROR err_inf,char *prefix);
void com_err_set_print_clear(PCOM_ERROR err_inf,char *prefix,const char *format,...) __attribute__((format(__printf__,3,4)));

int com_get_image_info(char *path,PCOM_IMAGE_INFO info,PCOM_ERROR err_inf);

int com_mapping_server_create(PCOM_MAPPING map,size_t size,char *name,void *idata,size_t idata_size,PCOM_ERROR err_inf);
int com_mapping_client_open(PCOM_MAPPING map,size_t size,char *name,void *idata,size_t idata_size,PCOM_ERROR err_inf);
void com_mapping_close(PCOM_MAPPING mapping);

int com_get_windows_path(char *path,size_t size,PCOM_ERROR err_inf);
int com_get_system_path(char *path,size_t size,PCOM_ERROR err_inf);
int com_get_drivers_path(char *path,size_t size,PCOM_ERROR err_inf);
int com_get_module_name(HMODULE module,char *name,size_t size,PCOM_ERROR err_inf);
int com_get_module_path(HMODULE module,char *name,size_t size,PCOM_ERROR err_inf);
int com_get_module_image_name(HMODULE module,char *name,size_t size,PCOM_ERROR err_inf);

int com_get_pid_from_name(ULONG *pid,char* name,PCOM_ERROR err_inf);
int com_get_name_from_pid(ULONG pid,char* name,size_t size,PCOM_ERROR err_inf);
int com_get_tids_from_pid(ULONG pid,ULONG *tids,int *tids_cnt,PCOM_ERROR err_inf);
int com_get_parent_info(ULONG pid,ULONG *ppid,char *name,size_t size,PCOM_ERROR err_inf);
int com_get_process_windows(ULONG pid,HWND *windows,int *windows_cnt,PCOM_ERROR err_inf);
int com_process_open(ULONG pid,DWORD access,int alternative,int verbose,HANDLE *handle,PCOM_ERROR err_inf);
int com_thread_open(ULONG tid,DWORD access,int alternative,int verbose,HANDLE *handle,PCOM_ERROR err_inf);
int com_proc_get_pids_from_names(char (*processes)[MAX_PATH],ULONG *pids,int cnt,PCOM_ERROR err_inf);
int com_proc_termination_report(char (*processes)[MAX_PATH],ULONG *pids,int cnt,PCOM_ERROR err_inf);

int com_find_pattern_and_print_data(char *data,size_t size,PCOM_CONF conf,PCOM_ERROR err_inf);

int com_security_info_set(HANDLE object,SE_OBJECT_TYPE type,SECURITY_INFORMATION info,DWORD access,ACCESS_MODE acmode,char *user,int merge,PCOM_ERROR err_inf);
int com_privilege_enable(char *priv_name,PCOM_ERROR err_inf);
int com_privilege_enable_debug(PCOM_ERROR err_inf);
int com_privilege_enable_shutdown(PCOM_ERROR err_inf);
int com_privilege_enable_backup(PCOM_ERROR err_inf);
int com_privilege_enable_restore(PCOM_ERROR err_inf);

int com_reg_key_copy(HKEY src_root,char *src_subkey,HKEY dst_root,char *dst_subkey);
int com_reg_root_name_to_hkey(char *root_name,HKEY *hkey,PCOM_ERROR err_inf);

int com_service_disable(char *svc_name,PCOM_ERROR err_inf);
int com_get_system_info_table(DWORD iclass,void **table,PCOM_ERROR err_inf);


extern FILE *conout;
extern FILE *conerr;


#ifdef __cplusplus
}
#endif

#endif
