/*

 Header file for Security Software Testing Suite - SSDT support shared code library
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#ifndef __LP_COMMON_SSDT_H__
#define __LP_COMMON_SSDT_H__

// structure of system service descriptor
typedef struct SERVICE_DESCRIPTOR_ENTRY
{
  unsigned int *ServiceTableBase;
  unsigned int *ServiceCounterTableBase;
  unsigned int NumberOfServices;
  unsigned char *ParamTableBase;
} SERVICE_DESCRIPTOR_ENTRY,*PSERVICE_DESCRIPTOR_ENTRY;

// maximum number of system services
#define COM_SSDT_MAX_FUNC_COUNT         0x1A0

// name of the physical memory section
#define COM_SSDT_PHYMEM_SECTION_NAME    L"\\Device\\PhysicalMemory"

// system service parameters array offset
#define COM_SSDT_PARAMS_OFFSET (SIZE_T)(&((PSERVICE_DESCRIPTOR_ENTRY)NULL)->ParamTableBase)



int com_ntkrnl_get_active_kernel_info(char *krnl,void **base,PCOM_ERROR err_inf);
int com_ntkrnl_get_original_ssdt(void** table,int *params,int *count,ULONG *offset,PCOM_ERROR err_inf);
int com_ssdt_restore_from_user_mode(PCOM_ERROR err_inf);

#endif
