/*

 Header file for Security Software Testing Suite - Shared code library for leak-tests
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#ifndef __LP_COMMON_LEAK_H__
#define __LP_COMMON_LEAK_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <windows.h>
#include <winsock.h>
#include "funcdef_kernel32.h"
#include "funcdef_ws2_32.h"

int com_get_default_browser_path(char *buffer,size_t size,PCOM_ERROR err_inf);
int com_get_default_browser_name(char *buffer,size_t size,PCOM_ERROR err_inf);
int com_get_default_browser_pid_wait(ULONG *pid,PCOM_ERROR err_inf);

int com_get_ie_path(char *buffer,size_t size,PCOM_ERROR err_inf);
int com_get_ie_pid_wait(ULONG *pid,PCOM_ERROR err_inf);

int com_attempt_wininet(char *buffer,size_t size,PCOM_CONF conf,PCOM_ERROR err_inf);
int com_attempt_dde(PCOM_CONF conf,int timeout,PCOM_ERROR err_inf);

int com_attempt_check_ie_cache(char *buffer,size_t size,PCOM_CONF conf,int timeout,PCOM_ERROR err_inf);

void com_uri_replace_eq(PCOM_CONF conf);

#ifdef __cplusplus
}
#endif

#endif
