/*

 BITS support header for Security Software Testing Suite
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#ifndef __BITS_HPP__
#define __BITS_HPP__

#ifdef __cplusplus
extern "C" {
#endif

#include <oaidl.h>
#include <ocidl.h>
#include <docobj.h>


typedef struct _BG_FILE_PROGRESS
{
  UINT64 BytesTotal;
  UINT64 BytesTransferred;
  BOOL Completed;
} BG_FILE_PROGRESS;


EXTERN_C const IID IID_IBackgroundCopyFile;
#undef INTERFACE
#define INTERFACE IBackgroundCopyFile
DECLARE_INTERFACE_(IBackgroundCopyFile,IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID,PVOID*) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;

  STDMETHOD(GetRemoteName)(THIS_ LPWSTR *) PURE;
  STDMETHOD(GetLocalName)(THIS_ LPWSTR *) PURE;
  STDMETHOD(GetProgress)(THIS_ BG_FILE_PROGRESS *) PURE;
};





EXTERN_C const IID IID_IEnumBackgroundCopyFiles;
#undef INTERFACE
#define INTERFACE IEnumBackgroundCopyFiles
DECLARE_INTERFACE_(IEnumBackgroundCopyFiles,IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID,PVOID*) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;

  STDMETHOD(Next)(THIS_ ULONG,IBackgroundCopyFile **,ULONG *) PURE;
  STDMETHOD(Skip)(THIS_ ULONG) PURE;
  STDMETHOD(Reset)(THIS) PURE;
  STDMETHOD(Clone)(THIS_ IEnumBackgroundCopyFiles **) PURE;
  STDMETHOD(GetCount)(THIS_ ULONG *) PURE;
};




typedef enum _BG_ERROR_CONTEXT
{
  BG_ERROR_CONTEXT_NONE                         = 0,
  BG_ERROR_CONTEXT_UNKNOWN                      = 1,
  BG_ERROR_CONTEXT_GENERAL_QUEUE_MANAGER        = 2,
  BG_ERROR_CONTEXT_QUEUE_MANAGER_NOTIFICATION   = 3,
  BG_ERROR_CONTEXT_LOCAL_FILE                   = 4,
  BG_ERROR_CONTEXT_REMOTE_FILE                  = 5,
  BG_ERROR_CONTEXT_GENERAL_TRANSPORT            = 6,
  BG_ERROR_CONTEXT_REMOTE_APPLICATION           = 7
} BG_ERROR_CONTEXT;

EXTERN_C const IID IID_IBackgroundCopyError;
#undef INTERFACE
#define INTERFACE IBackgroundCopyError
DECLARE_INTERFACE_(IBackgroundCopyError,IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID,PVOID*) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;

  STDMETHOD(GetError)(THIS_ BG_ERROR_CONTEXT *,HRESULT *) PURE;
  STDMETHOD(GetFile)(THIS_ IBackgroundCopyFile **) PURE;
  STDMETHOD(GetErrorDescription)(THIS_ DWORD,LPWSTR *) PURE;
  STDMETHOD(GetErrorContextDescription)(THIS_ DWORD,LPWSTR *) PURE;
  STDMETHOD(GetProtocol)(THIS_ LPWSTR *) PURE;
};





typedef struct _BG_FILE_INFO
{
  LPWSTR RemoteName;
  LPWSTR LocalName;
} BG_FILE_INFO;

typedef struct _BG_JOB_PROGRESS
{
  UINT64 BytesTotal;
  UINT64 BytesTransferred;
  ULONG FilesTotal;
  ULONG FilesTransferred;
} BG_JOB_PROGRESS;

typedef struct _BG_JOB_TIMES
{
  FILETIME CreationTime;
  FILETIME ModificationTime;
  FILETIME TransferCompletionTime;
} BG_JOB_TIMES;

typedef enum _BG_JOB_PRIORITY
{
  BG_JOB_PRIORITY_FOREGROUND    = 0,
  BG_JOB_PRIORITY_HIGH          = BG_JOB_PRIORITY_FOREGROUND + 1,
  BG_JOB_PRIORITY_NORMAL        = BG_JOB_PRIORITY_HIGH + 1,
  BG_JOB_PRIORITY_LOW           = BG_JOB_PRIORITY_NORMAL + 1
} BG_JOB_PRIORITY;

typedef enum _BG_JOB_STATE
{
  BG_JOB_STATE_QUEUED           = 0,
  BG_JOB_STATE_CONNECTING       = BG_JOB_STATE_QUEUED + 1,
  BG_JOB_STATE_TRANSFERRING     = BG_JOB_STATE_CONNECTING + 1,
  BG_JOB_STATE_SUSPENDED        = BG_JOB_STATE_TRANSFERRING + 1,
  BG_JOB_STATE_ERROR            = BG_JOB_STATE_SUSPENDED + 1,
  BG_JOB_STATE_TRANSIENT_ERROR  = BG_JOB_STATE_ERROR + 1,
  BG_JOB_STATE_TRANSFERRED      = BG_JOB_STATE_TRANSIENT_ERROR + 1,
  BG_JOB_STATE_ACKNOWLEDGED     = BG_JOB_STATE_TRANSFERRED + 1,
  BG_JOB_STATE_CANCELLED        = BG_JOB_STATE_ACKNOWLEDGED + 1
} BG_JOB_STATE;

typedef enum _BG_JOB_TYPE
{
  BG_JOB_TYPE_DOWNLOAD  = 0,
  BG_JOB_TYPE_UPLOAD  = BG_JOB_TYPE_DOWNLOAD + 1,
  BG_JOB_TYPE_UPLOAD_REPLY  = BG_JOB_TYPE_UPLOAD + 1
} BG_JOB_TYPE;

typedef enum _BG_JOB_PROXY_USAGE
{
  BG_JOB_PROXY_USAGE_PRECONFIG  = 0,
  BG_JOB_PROXY_USAGE_NO_PROXY   = BG_JOB_PROXY_USAGE_PRECONFIG + 1,
  BG_JOB_PROXY_USAGE_OVERRIDE   = BG_JOB_PROXY_USAGE_NO_PROXY + 1,
  BG_JOB_PROXY_USAGE_AUTODETECT = BG_JOB_PROXY_USAGE_OVERRIDE + 1
} BG_JOB_PROXY_USAGE;


EXTERN_C const IID IID_IBackgroundCopyJob;
#undef INTERFACE
#define INTERFACE IBackgroundCopyJob
DECLARE_INTERFACE_(IBackgroundCopyJob,IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID,PVOID*) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;

  STDMETHOD(AddFileSet)(THIS_ ULONG,BG_FILE_INFO*) PURE;
  STDMETHOD(AddFile)(THIS_ LPCWSTR,LPCWSTR) PURE;
  STDMETHOD(EnumFiles)(THIS_ IEnumBackgroundCopyFiles **) PURE;
  STDMETHOD(Suspend)(THIS) PURE;
  STDMETHOD(Resume)(THIS) PURE;
  STDMETHOD(Cancel)(THIS) PURE;
  STDMETHOD(Complete)(THIS) PURE;
  STDMETHOD(GetId)(THIS_ GUID *) PURE;
  STDMETHOD(GetType)(THIS_ BG_JOB_TYPE *) PURE;
  STDMETHOD(GetProgress)(THIS_ BG_JOB_PROGRESS *) PURE;
  STDMETHOD(GetTimes)(THIS_ BG_JOB_TIMES *) PURE;
  STDMETHOD(GetState)(THIS_ BG_JOB_STATE *) PURE;
  STDMETHOD(GetError)(THIS_ IBackgroundCopyError **) PURE;
  STDMETHOD(GetOwner)(THIS_ LPWSTR *) PURE;
  STDMETHOD(SetDisplayName)(THIS_ LPCWSTR) PURE;
  STDMETHOD(GetDisplayName)(THIS_ LPWSTR *) PURE;
  STDMETHOD(SetDescription)(THIS_ LPCWSTR) PURE;
  STDMETHOD(GetDescription)(THIS_ LPWSTR *) PURE;
  STDMETHOD(SetPriority)(THIS_ BG_JOB_PRIORITY) PURE;
  STDMETHOD(GetPriority)(THIS_ BG_JOB_PRIORITY *) PURE;
  STDMETHOD(SetNotifyFlags)(THIS_ ULONG) PURE;
  STDMETHOD(GetNotifyFlags)(THIS_ ULONG *) PURE;
  STDMETHOD(SetNotifyInterface)(THIS_ IUnknown *) PURE;
  STDMETHOD(GetNotifyInterface)(THIS_ IUnknown **) PURE;
  STDMETHOD(SetMinimumRetryDelay)(THIS_ ULONG) PURE;
  STDMETHOD(GetMinimumRetryDelay)(THIS_ ULONG *) PURE;
  STDMETHOD(SetNoProgressTimeout)(THIS_ ULONG) PURE;
  STDMETHOD(GetNoProgressTimeout)(THIS_ ULONG *) PURE;
  STDMETHOD(GetErrorCount)(THIS_ ULONG *) PURE;
  STDMETHOD(SetProxySettings)(THIS_ BG_JOB_PROXY_USAGE,const WCHAR *,const WCHAR *) PURE;
  STDMETHOD(GetProxySettings)(THIS_ BG_JOB_PROXY_USAGE*,LPWSTR *,LPWSTR *) PURE;
  STDMETHOD(TakeOwnership)(THIS) PURE;
};



EXTERN_C const IID IID_IEnumBackgroundCopyJobs;
#undef INTERFACE
#define INTERFACE IEnumBackgroundCopyJobs
DECLARE_INTERFACE_(IEnumBackgroundCopyJobs,IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID,PVOID*) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;

  STDMETHOD(Next)(THIS_ ULONG,IBackgroundCopyJob **,ULONG *) PURE;
  STDMETHOD(Skip)(THIS_ ULONG) PURE;
  STDMETHOD(Reset)(THIS) PURE;
  STDMETHOD(Clone)(THIS_ IEnumBackgroundCopyJobs **) PURE;
  STDMETHOD(GetCount)(THIS_ ULONG *) PURE;
};






EXTERN_C const IID IID_IBackgroundCopyManager;
#undef INTERFACE
#define INTERFACE IBackgroundCopyManager
DECLARE_INTERFACE_(IBackgroundCopyManager,IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID,PVOID*) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;

  STDMETHOD(CreateJob)(THIS_ LPCWSTR,BG_JOB_TYPE,GUID *,IBackgroundCopyJob **) PURE;
  STDMETHOD(GetJob)(THIS_ REFGUID,IBackgroundCopyJob **) PURE;
  STDMETHOD(EnumJobs)(THIS_ DWORD,IEnumBackgroundCopyJobs **) PURE;
  STDMETHOD(GetErrorDescription)(THIS_ HRESULT,DWORD,LPWSTR *) PURE;
};


const IID CLSID_BackgroundCopyManager   = {0x4991D34B, 0x80A1, 0x4291, {0x83, 0xB6, 0x33, 0x28, 0x36, 0x6B, 0x90, 0x97}};
const IID IID_IBackgroundCopyManager    = {0x5CE34C0D, 0x0DC9, 0x4C1F, {0x89, 0x7C, 0xDA, 0xA1, 0xB7, 0x8C, 0xEE, 0x7C}};

#ifdef __cplusplus
}
#endif

#endif
