/*

 Security Software Testing Suite - FireHole (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by FireHole, written by Robin Keir, http://keir.net/firehole.html.

   * This technique is used by pcAudit and pcAudit 2, written by Internet Security Alliance.


 Method description:

   * Windows API SetWindowsHookEx allows applications to install a windows hook and define
     a handler routine for it. A handler routine is a part of DLL, which is loaded to the process
     of the thread in which the windows message were hooked.

   * This test locates the default browser's process and installs a windows hook to one of its threads.

   * "fireholedll.dll" that hosts the hook handler function is loaded into the default browser
     and its code is executed. This code attempts to connect to the Internet server.

*/


#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  if (!com_console_init_main("FireHole","firehole",argc,argv,&conf,COM_TEST_TYPE_FIREHOLE)) return 1;

  char *used_dlls[]={"user32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;
  char *err_prefix=COM_ERR_STANDARD_PREFIX;

  ULONG pid;
  if (com_get_default_browser_pid_wait(&pid,&err_inf))
  {
    if (com_verbosity_get()) printf("The default browser's process found (PID = %ld).\n",pid);

    ULONG tid;
    int tids_cnt=1;
    if (com_get_tids_from_pid(pid,&tid,&tids_cnt,&err_inf))
    {
      if (com_verbosity_get()) printf("The target thread selected (TID = %ld).\n",tid);

      PCOM_MAPPING map=&conf.map;
      if (com_mapping_server_create(map,COM_MAP_DEFAULT_DATA_SIZE_MAX,"FireHole",&conf,sizeof(conf),&err_inf))
      {
        HMODULE helper_dll=LoadLibrary("fireholedll.dll");
        if (helper_dll)
        {
          void *callback=GetProcAddress(helper_dll,"CallWndRetProc");
          if (callback)
          {
            HHOOK hook=SetWindowsHookEx(WH_CALLWNDPROCRET,callback,helper_dll,tid);

            if (hook)
            {
              if (com_verbosity_get()) printf("Hook installed, waiting for response ...\n");

              DWORD wres=WaitForSingleObject(map->event,30000);
              switch (wres)
              {
                case WAIT_OBJECT_0:
                {
                  if (map->data->error.occurred)
                  {
                    err_prefix="\nTARGET PROCESS ERROR: ";
                    memcpy(&err_inf,&map->data->error,sizeof(err_inf));
                  } else res=com_find_pattern_and_print_data(map->data->buffer,sizeof(map->data->buffer),&conf,&err_inf);
                  break;
                }

                case WAIT_TIMEOUT:
                  com_err_set_nc(&err_inf,"Waiting timed out.\n");
                  break;

                default:
                  if (wres!=WAIT_FAILED) SetLastError(ERROR_SUCCESS);
                  com_err_set(&err_inf,"Unknown error occurred, WaitForSingleObject returned %ld.\n",wres);
              }

              UnhookWindowsHookEx(hook);
            } else com_err_set(&err_inf,"Unable to install windows hook.\n");
          } else com_err_set(&err_inf,"Unable to find function \"CallWndRetProc\" in \"fireholedll.dll\".\n");

          FreeLibrary(helper_dll);
        } else com_err_set(&err_inf,"Unable to load library \"fireholedll.dll\".\n");

        com_mapping_close(map);
      }
    }
  }

  return com_end_pref(res,&err_inf,&conf,err_prefix);
}
