/*

 Security Software Testing Suite - ECHOtest2 (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the code and original idea of COMODO Outbound Connection Tests For Firewalls - ICMP 2
     by Comodo Group, http://www.comodo.com/.


 Method description:

   * Use IP Helper functions to send the data to the Internet server in ICMP ECHO request.

*/


#include <stdio.h>
#include <windows.h>
#include <winsock.h>
#include <ipexport.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "include/funcdef_icmp.h"


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("ECHOtest2","echotest2",argc,argv,&conf,COM_TEST_TYPE_ECHOTEST2)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","icmp.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  int res=FALSE;

  char ip_str[32];
  lstrcpynA(ip_str,inet_ntoa(conf.ip),sizeof(ip_str));

  WSADATA wsadata;
  int err=WSAStartup(MAKEWORD(1,1),&wsadata);
  if (!err)
  {
    HMODULE mod=LoadLibrary("icmp.dll");
    if (mod)
    {
      if (com_verbosity_get()) printf("\"icmp.dll\" loaded at 0x%p.\n",mod);

      ICMP_CREATE_FILE IcmpCreateFile=(ICMP_CREATE_FILE)GetProcAddress(mod,"IcmpCreateFile");
      if (IcmpCreateFile)
      {
        if (com_verbosity_get()) printf("IcmpCreateFile found in \"icmp.dll\" at 0x%p.\n",IcmpCreateFile);

        ICMP_CLOSE_HANDLE IcmpCloseHandle=(ICMP_CLOSE_HANDLE)GetProcAddress(mod,"IcmpCloseHandle");
        if (IcmpCloseHandle)
        {
          if (com_verbosity_get()) printf("IcmpCloseHandle found in \"icmp.dll\" at 0x%p.\n",IcmpCloseHandle);

          ICMP_SEND_ECHO IcmpSendEcho=(ICMP_SEND_ECHO)GetProcAddress(mod,"IcmpSendEcho");
          if (IcmpSendEcho)
          {
            if (com_verbosity_get()) printf("IcmpSendEcho found in \"icmp.dll\" at 0x%p.\n\n",IcmpSendEcho);

            HANDLE icmp_file=IcmpCreateFile();
            if (icmp_file!=INVALID_HANDLE_VALUE)
            {
              if (com_verbosity_get()) printf("Sending ICMP echo request to %s ...\n",inet_ntoa(conf.ip));

              char buffer[COM_INET_DATA_MAX_LEN+COM_INET_MAGIC_MAX_LEN+4];
              snprintf(buffer,sizeof(buffer),"%s|%s",conf.data,conf.magic);
              buffer[sizeof(buffer)-1]='\0';
              int len=strlen(buffer);

              IP_OPTION_INFORMATION options;
              memset(&options,0,sizeof(options));
              options.Ttl=255;

              char buffer_reply[sizeof(ICMP_ECHO_REPLY)+COM_INET_DATA_MAX_LEN+COM_INET_MAGIC_MAX_LEN+4];
              PICMP_ECHO_REPLY reply=(PICMP_ECHO_REPLY)buffer_reply;

              if (IcmpSendEcho(icmp_file,conf.ip.S_un.S_addr,buffer,len,&options,reply,sizeof(buffer_reply),10000))
              {
                if (reply->Status==IP_SUCCESS)
                {
                  res=strstr(reply->Data,conf.magic)!=NULL;

                  struct in_addr rep_addr;
                  rep_addr.S_un.S_addr=reply->Address;
                  if (res) printf("Response received from %s in %ld ms.\n",inet_ntoa(rep_addr),reply->RoundTripTime);
                  else com_err_set_nc(&err_inf,"Magic pattern not found.\n");
                } else com_err_set(&err_inf,"ICMP echo request failed with status %ld.\n",reply->Status);
              } else com_err_set(&err_inf,"Unable to send IPv4 ICMP echo request to %s.\n",ip_str);

              IcmpCloseHandle(icmp_file);
            } else com_err_set(&err_inf,"Unable to open IPv4 ICMP interface.\n");
          } else com_err_set(&err_inf,"Unable to find IcmpSendEcho function in library \"icmp.dll\".\n");
        } else com_err_set(&err_inf,"Unable to find IcmpCloseHandle function in library \"icmp.dll\".\n");
      } else com_err_set(&err_inf,"Unable to find IcmpCreateFile function in library \"icmp.dll\".\n");
    } else com_err_set(&err_inf,"Unable to load library \"icmp.dll\".\n");

    WSACleanup();
  } else com_err_set_sc(&err_inf,err,"Unable to initialize Windows Sockets.\n");

  return com_end(res,&err_inf,&conf);
}
