/*

 Security Software Testing Suite - Helper driver
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

 This driver is used by tests that attempt to load driver to the operating system kernel.
 The driver's device can be opened and requested to confirm that the driver is loaded
 and working. Being in the kernel always means a possibility to bypass arbitrary
 security features.

*/

#include <wdm.h>
#include "drv.h"

#ifdef __cplusplus
extern "C"
{
#endif

NTSTATUS drv_create(PDEVICE_OBJECT DeviceObject,PIRP Irp);
NTSTATUS drv_cleanup(PDEVICE_OBJECT DeviceObject,PIRP Irp);
NTSTATUS drv_shutdown(PDEVICE_OBJECT DeviceObject,PIRP Irp);
void drv_unload(PDEVICE_OBJECT DeviceObject);
void drv_free(PDEVICE_OBJECT DeviceObject);
NTSTATUS DriverEntry(PDRIVER_OBJECT DriverObject,PUNICODE_STRING RegistryPath);

#ifdef __cplusplus
}
#endif




// The driver's DOS device name symbolic link to be used by unloading function.
UNICODE_STRING dev_name_dos;


/*
 The driver's dispatch create routine.
 Simply completes the IRP_MJ_CREATE request.

 For arguments and return value descriptions, see WDK documention of DispatchCreate.
*/

NTSTATUS drv_create(PDEVICE_OBJECT DeviceObject,PIRP Irp)
{
  Irp->IoStatus.Status=STATUS_SUCCESS;
  Irp->IoStatus.Information=0;
  IoCompleteRequest(Irp,IO_NO_INCREMENT);

  return STATUS_SUCCESS;
}


/*
 The driver's dispatch cleanup routine.
 Simply completes the IRP_MJ_CLEANUP request.

 For arguments and return value descriptions, see WDK documention of DispatchCleanup.
*/

NTSTATUS drv_cleanup(PDEVICE_OBJECT DeviceObject,PIRP Irp)
{
  Irp->IoStatus.Status=STATUS_SUCCESS;
  Irp->IoStatus.Information=0;
  IoCompleteRequest(Irp,IO_NO_INCREMENT);

  return STATUS_SUCCESS;
}


/*
 The driver's shutdown routine.
 Frees resources used by driver.

 For arguments and return value descriptions, see WDK documention of DispatchShutdown.
*/

NTSTATUS drv_shutdown(PDEVICE_OBJECT DeviceObject,PIRP Irp)
{
  drv_free(DeviceObject);

  return STATUS_SUCCESS;
}


/*
 The driver's dispatch device control routine.
 Answers requests of user mode parts.

 For arguments and return value descriptions, see WDK documention of DispatchDeviceControl.
*/

NTSTATUS drv_device_control(PDEVICE_OBJECT DeviceObject,PIRP Irp)
{
  PIO_STACK_LOCATION stack=IoGetCurrentIrpStackLocation(Irp);

  NTSTATUS status=STATUS_INVALID_DEVICE_REQUEST;
  ULONG code=stack->Parameters.DeviceIoControl.IoControlCode;
  if (code==IOCTL_SSTS_PING)
  {
    Irp->IoStatus.Status=STATUS_SUCCESS;
    Irp->IoStatus.Information=0;
    status=STATUS_SUCCESS;
  } else
  {
    Irp->IoStatus.Status=STATUS_INVALID_DEVICE_REQUEST;
    Irp->IoStatus.Information=0;
  }

  IoCompleteRequest(Irp,IO_NO_INCREMENT);
  return status;
}



/*
 The driver's unload routine.
 Frees resources used by the driver.

 For argument description, see WDK documention of Unload.
*/

void drv_unload(PDRIVER_OBJECT DriverObject)
{
  drv_free(DriverObject->DeviceObject);

  return;
}


/*
 Frees resources used by the driver.

 'DeviceObject' The driver's device object.
*/

void drv_free(PDEVICE_OBJECT DeviceObject)
{
  IoDeleteSymbolicLink(&dev_name_dos);
  IoUnregisterShutdownNotification(DeviceObject);
  IoDeleteDevice(DeviceObject);

  return;
}



NTSTATUS DriverEntry(PDRIVER_OBJECT DriverObject,PUNICODE_STRING RegistryPath)
{
  int load_normal=FALSE;

  UCHAR buffer[sizeof(KEY_VALUE_PARTIAL_INFORMATION)+260*sizeof(wchar_t)];
  PKEY_VALUE_PARTIAL_INFORMATION info=(PKEY_VALUE_PARTIAL_INFORMATION)buffer;

  HANDLE hkey_conf=NULL;

  UNICODE_STRING us_conf;
  RtlInitUnicodeString(&us_conf,L"\\REGISTRY\\MACHINE\\Software\\SSTS");

  OBJECT_ATTRIBUTES oa_conf;
  InitializeObjectAttributes(&oa_conf,&us_conf,OBJ_CASE_INSENSITIVE | OBJ_KERNEL_HANDLE,NULL,NULL);

  NTSTATUS status=ZwOpenKey(&hkey_conf,KEY_ALL_ACCESS,&oa_conf);
  if (NT_SUCCESS(status))
  {
    UNICODE_STRING val_name;
    RtlInitUnicodeString(&val_name,L"drvbin");

    ULONG ret_len;
    status=ZwQueryValueKey(hkey_conf,&val_name,KeyValuePartialInformation,info,sizeof(buffer),&ret_len);
  } else if (status==STATUS_OBJECT_NAME_NOT_FOUND) load_normal=TRUE;

  if (NT_SUCCESS(status))
  {
    if (NT_SUCCESS(status))
    {
      void* reg=ExAllocatePoolWithTag(NonPagedPool,PAGE_SIZE,DRV_POOL_TAG);
      if (reg)
      {
        PUNICODE_STRING us=(PUNICODE_STRING)reg;
        WCHAR *buf=(WCHAR*)((size_t)reg+sizeof(UNICODE_STRING));
        WCHAR *name=L"\\REGISTRY\\MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SSTSdrv";
        RtlCopyMemory(buf,name,(wcslen(name)+1)*sizeof(WCHAR));

        RtlInitUnicodeString(us,buf);

        HANDLE hkey;
        OBJECT_ATTRIBUTES oa;
        InitializeObjectAttributes(&oa,us,OBJ_CASE_INSENSITIVE | OBJ_KERNEL_HANDLE | OBJ_OPENIF,NULL,NULL);

        status=ZwCreateKey(&hkey,KEY_ALL_ACCESS,&oa,0,NULL,REG_OPTION_VOLATILE,NULL);
        if (NT_SUCCESS(status))
        {
          UNICODE_STRING val_name;
          RtlInitUnicodeString(&val_name,L"ImagePath");

          status=ZwSetValueKey(hkey,&val_name,0,REG_EXPAND_SZ,info->Data,info->DataLength);
          if (NT_SUCCESS(status))
          {
            ULONG type=1;
            RtlInitUnicodeString(&val_name,L"Type");
            status=ZwSetValueKey(hkey,&val_name,0,REG_DWORD,&type,sizeof(type));

            if (NT_SUCCESS(status))
            {
              status=ZwDeleteKey(hkey_conf);
              if (NT_SUCCESS(status))
              {
                ZwClose(hkey_conf);
                hkey_conf=NULL;

                status=ZwLoadDriver(us);
                if (NT_SUCCESS(status))
                {
                  status=STATUS_REQUEST_ABORTED;
                }
              }
            }
          }

          ZwClose(hkey);
        }

        ExFreePoolWithTag(reg,DRV_POOL_TAG);
      } else status=STATUS_INSUFFICIENT_RESOURCES;
    }
  } else if (load_normal)
  {
    UNICODE_STRING dev_name;
    RtlInitUnicodeString(&dev_name,DRV_DEVICE_NAME);
    RtlInitUnicodeString(&dev_name_dos,DRV_DEVICE_NAME_DOS);

    PDEVICE_OBJECT dev_obj=NULL;
    status=IoCreateDevice(DriverObject,0,&dev_name,FILE_DEVICE_UNKNOWN,FILE_DEVICE_SECURE_OPEN,FALSE,&dev_obj);
    if (NT_SUCCESS(status))
    {
      DriverObject->MajorFunction[IRP_MJ_CREATE]          = drv_create;
      DriverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL]  = drv_device_control;
      DriverObject->MajorFunction[IRP_MJ_CLEANUP]         = drv_cleanup;
      DriverObject->MajorFunction[IRP_MJ_SHUTDOWN]        = drv_shutdown;
      DriverObject->DriverUnload                          = drv_unload;

      dev_obj->Flags|=DO_BUFFERED_IO;

      status=IoRegisterShutdownNotification(dev_obj);
      if (NT_SUCCESS(status))
      {
        status=IoCreateSymbolicLink(&dev_name_dos,&dev_name);
        if (NT_SUCCESS(status))
        {

          if (!NT_SUCCESS(status)) IoDeleteSymbolicLink(&dev_name_dos);
        }

        if (!NT_SUCCESS(status)) IoUnregisterShutdownNotification(dev_obj);
      }

      if (!NT_SUCCESS(status)) IoDeleteDevice(DriverObject->DeviceObject);
    }
  }

  if (hkey_conf) ZwClose(hkey_conf);

  return status;
}
