/*

 Helper DLL for Security Software Testing Suite - CPILSuite2 (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

 This DLL is loaded into Windows Explorer and its callback function WinEventProc() is executed.
 When this DLL is loaded it starts a new process with the command line from the mapping.

*/


#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-leak.h"


VOID CALLBACK WinEventProc(HWINEVENTHOOK hWinEventHook,DWORD event,HWND hwnd,LONG idObject,LONG idChild,DWORD dwEventThread,DWORD dwmsEventTime);
BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID lpvReserved);


/*
 Event hook function that does nothing - all the work is done by DllMain().
 See 'lpfnWinEventProc' parameter of SetWinEventHook API for more information.
*/

VOID CALLBACK WinEventProc(HWINEVENTHOOK hWinEventHook,DWORD event,HWND hwnd,LONG idObject,LONG idChild,DWORD dwEventThread,DWORD dwmsEventTime)
{
  return;
}


BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID lpvReserved)
{
  if (fdwReason==DLL_PROCESS_ATTACH)
  {
    char hostname[MAX_PATH];

    GetModuleFileName(NULL,hostname,sizeof(hostname));
    char *filename=strrchr(hostname,'\\');
    if (filename) filename++;
    else filename=hostname;

    if (stricmp(filename,"cpilsuite2.exe"))                     // if NOT in cpilsuite2.exe
    {
      COM_ERROR temp,*err_inf;
      COM_MAPPING map;
      char cmdline[MAX_PATH+COM_INET_URI_MAX_LEN];
      if (com_mapping_client_open(&map,COM_MAP_DEFAULT_DATA_SIZE_MAX,"CPILSuite2",cmdline,sizeof(cmdline),&temp))
      {
        STARTUPINFO si;
        PROCESS_INFORMATION pi;
        memset(&si,0,sizeof(si));
        si.cb=sizeof(si);

        err_inf=&map.data->error;
        if (CreateProcess(NULL,cmdline,NULL,NULL,FALSE,0,NULL,NULL,&si,&pi))
        {
          CloseHandle(pi.hProcess);
          CloseHandle(pi.hThread);
        } else com_err_set(err_inf,"Unable to create process with command line \"%s\".\n",cmdline);

        SetEvent(map.event);

        com_mapping_close(&map);
      }
    }
  }

  return TRUE;
}
