/*

 Security Software Testing Suite - BITStest (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * The original idea by Tim Fish.

   * The first implementation using BITS for leak-testing by Guillaume Kaddouch, http://www.firewallleaktester.com/news.htm#57.

   * Based on the code by Frank Boldevin http://www.reconstructer.org/.


 Method description:

   * Background Intelligent Transfer Service must not be disabled.

   * Use IBackgroundCopyManager hosted by BITS service to download the file from the Internet.

   * The interface is documented in MSDN: http://msdn.microsoft.com/en-us/library/aa363050.aspx

*/

#include <windows.h>
#include <stdio.h>
#include <objbase.h>
#include "include/bits.hpp"
#include "include/common.h"
#include "include/common-hook.h"


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  COM_CONF conf;
  if (!com_console_init_winmain("BITStest","bitstest",lpCmdLine,&conf,COM_TEST_TYPE_BITSTEST)) return 1;

  char *used_dlls[]={"ole32.dll","oleaut32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  char path[MAX_PATH];
  if (com_get_module_path(NULL,path,sizeof(path),&err_inf))
  {
    HRESULT hres=CoInitialize(NULL);
    if (SUCCEEDED(hres))
    {
      IBackgroundCopyManager *bgcm;
      hres=CoCreateInstance(CLSID_BackgroundCopyManager,NULL,CLSCTX_LOCAL_SERVER,IID_IBackgroundCopyManager,(void**)&bgcm);
      if (SUCCEEDED(hres))
      {
        if (com_verbosity_get()) printf("IBackgroundCopyManager instance created.\n");

        GUID job_id;
        IBackgroundCopyJob *bgcj;
        hres=bgcm->CreateJob(L"BITStest",BG_JOB_TYPE_DOWNLOAD,&job_id,&bgcj);
        if (SUCCEEDED(hres))
        {
          if (com_verbosity_get()) printf("Copy job created.\n");

          char local[MAX_PATH];
          wchar_t remotew[COM_INET_URI_MAX_LEN],localw[MAX_PATH];
          snwprintf(remotew,COM_INET_URI_MAX_LEN,L"%S",conf.uri);
          remotew[COM_INET_URI_MAX_LEN-1]=L'\0';

          snprintf(local,MAX_PATH,"%s\\test.failed",path);
          local[MAX_PATH-1]='\0';
          snwprintf(localw,MAX_PATH,L"%S",local);
          localw[MAX_PATH-1]=L'\0';

          hres=bgcj->AddFile(remotew,localw);
          if (SUCCEEDED(hres))
          {
            if (com_verbosity_get()) printf("File \"%S\" added to the job and will be downloaded to \"%S\".\n",remotew,localw);

            hres=bgcj->Resume();
            if (SUCCEEDED(hres))
            {
              if (com_verbosity_get()) printf("The job has been resumed.\n");

              int done=FALSE,noerr=TRUE;
              while (!done)
              {
                BG_JOB_STATE state;
                hres=bgcj->GetState(&state);
                if (SUCCEEDED(hres))
                {
                  switch (state)
                  {
                    case BG_JOB_STATE_ERROR:
                      com_err_set_nc(&err_inf,"Unable to download \"%S\" to \"%S\".\n",remotew,localw);
                      done=TRUE;
                      noerr=FALSE;
                      break;

                    case BG_JOB_STATE_TRANSFERRED:
                      if (com_verbosity_get()) printf("File \"%S\" has been downloaded to \"%S\".\n",remotew,localw);
                      bgcj->Complete();
                      done=TRUE;
                      break;

                    default:
                      Sleep(500);
                  }
                } else
                {
                  com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to get state of the job.\n");
                  break;
                }
              }

              if (noerr)
              {
                HANDLE file=CreateFile(local,GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL);
                if (file!=INVALID_HANDLE_VALUE)
                {
                  char buffer[COM_MAP_DEFAULT_DATA_BUFFER_SIZE_MAX];
                  memset(buffer,0,sizeof(buffer));
                  DWORD read;
                  if (ReadFile(file,buffer,sizeof(buffer),&read,NULL))
                  {
                    buffer[sizeof(buffer)]='\0';
                    res=com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);
                  } else com_err_set(&err_inf,"Unable to read data from file \"%s\".\n",local);

                  CloseHandle(file);
                  DeleteFile(local);
                } else com_err_set(&err_inf,"Unable to open file \"%s\".\n",local);
              }
            } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to resume the job.\n");
          } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to add file \"%S\" to the job.\n",remotew);

          bgcj->Release();
        } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to create copy job.\n");

        bgcm->Release();
      } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to create instance of IBackgroundCopyManager.\n");

      CoUninitialize();
    } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to initialize COM.\n");
  }

  return com_end(res,&err_inf,&conf);
}
