/*

 Security Software Testing Suite - Leaktest (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * The original idea by Gibson Research Corporation, http://www.grc.com/.


 Method description:

   * Simply try to access the Internet. This test was created in stone age
     of security software era and simply tests whether the tested system
     implements control of outbound TCP packets.

*/


#include <stdio.h>
#include <windows.h>
#include <winsock.h>
#include "include/common.h"
#include "include/common-univ.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("Leaktest","leaktest",argc,argv,&conf,COM_TEST_TYPE_LEAKTEST)) return 1;

  char *used_dlls[]={"kernel32.dll","ws2_32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  struct sockaddr_in server;
  char data[COM_INET_URI_MAX_LEN];

  com_univ_inet_sock_http_init(&server,data,sizeof(data),&conf);
  size_t data_len=strlen(data);

  PCOM_UNIV_JOB job;

  if (com_univ_job_init(2,sizeof(server)+sizeof(data_len)+data_len,4,&job,&err_inf))
  {
    com_univ_job_stack_init_push(job,data,data_len);
    com_univ_job_stack_init_push(job,&data_len,sizeof(data_len));
    com_univ_job_stack_init_push(job,&server,sizeof(server));

    com_univ_job_action_set(job,0,COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS,com_univ_load_second_dll);
    com_univ_job_action_set(job,1,0,com_univ_inet_sock_http);

    PCOM_UNIV univ=NULL;
    if (com_univ_init(COM_UNIV_INIT_FLAG_WS2_32,"Leaktest",1,&job,&univ,&err_inf))
    {
      COM_UNIV_DATA data;
      univ->server_mapping.data=&data;

      com_univ_main(univ);

      if (!univ->error.occurred)
      {
        memcpy(&univ->error,&univ->server_mapping.data->error,sizeof(univ->error));

        if (!univ->error.occurred)
          res=com_find_pattern_and_print_data(univ->server_mapping.data->buffer,sizeof(univ->server_mapping.data->buffer),&conf,&err_inf);
      }

      if (univ->error.occurred)
        com_univ_server_err_report(univ,&err_inf);

      com_univ_finit(univ);
    }

    com_univ_job_finit(job);
  }

  return com_end(res,&err_inf,&conf);
}
