/*

 Security Software Testing Suite - Kill6 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * A similar technique is used by Advanced Process Termination - Kill 8, written by Diamond Computer Systems,
     http://www.diamondcs.com.au/.

   * A similar technique is also used by Simple Process Termination - Method 8, written by System Safety Limited.

   * Thanks for an improvement suggestion to wj32, wj32.64@gmail.com.


 Method description:

   * Obtain the Debug privilege.

   * Use NtCreateDebugObject and NtDebugActiveProcess API functions to create a debug object and attach
     the target processes as a debugger.

   * Closing the debug object causes termination of the attached processes.

   * This test works with a list of processes and reports success if at least one process was attached.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"

#define DEBUG_OBJECT_TERMINATE  0x2

typedef NTSTATUS NTAPI (*NT_CREATE_DEBUG_OBJECT)(PHANDLE DebugObject,ULONG AccessRequired,POBJECT_ATTRIBUTES ObjectAttributes,BOOLEAN KillProcessOnExit);
typedef NTSTATUS NTAPI (*NT_DEBUG_ACTIVE_PROCESS)(HANDLE Process,HANDLE DebugObject);


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Kill6","kill6",argc,argv,&conf,COM_TEST_TYPE_KILL6)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

  HMODULE ntdll=GetModuleHandle("ntdll.dll");
  if (ntdll)
  {
    NT_CREATE_DEBUG_OBJECT NtCreateDebugObject=(void*)GetProcAddress(ntdll,"NtCreateDebugObject");
    if (NtCreateDebugObject)
    {
      NT_DEBUG_ACTIVE_PROCESS NtDebugActiveProcess=(void*)GetProcAddress(ntdll,"NtDebugActiveProcess");
      if (NtDebugActiveProcess)
      {
        ULONG pids[conf.processes_cnt];
        int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
        if (ret)
        {
          HANDLE dbg_obj=NULL;
          OBJECT_ATTRIBUTES oa;
          InitializeObjectAttributes(&oa,NULL,0,NULL,NULL);
          NTSTATUS status=NtCreateDebugObject(&dbg_obj,DEBUG_OBJECT_TERMINATE,&oa,TRUE);
          if (NT_SUCCESS(status))
          {
            for (int i=0;i<conf.processes_cnt;i++)
            {
              if (pids[i]!=COM_CID_INVALID)
              {
                if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pids[i]);

                HANDLE proc=NULL;
                if (com_process_open(pids[i],PROCESS_SUSPEND_RESUME,TRUE,TRUE,&proc,&err_inf))
                {
                  status=NtDebugActiveProcess(proc,dbg_obj);
                  if (NT_SUCCESS(status))
                  {
                    printf("Process \"%s\" (PID %ld) attached and will be terminated.\n",conf.processes[i],pids[i]);
                  } else com_err_set_nc(&err_inf,"Unable to attach debug object to process \"%s\" (PID %ld), error status 0x%lX.\n",
                         conf.processes[i],pids[i],status);

                  CloseHandle(proc);
                } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);
              } else if (ret) fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);
            }

            CloseHandle(dbg_obj);
            res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);
          } else com_err_set_nc(&err_inf,"Unable to create debug object, error status 0x%lX.\n",status);
        }
      } else com_err_set(&err_inf,"Unable to find \"NtDebugActiveProcess\" in \"ntdll.dll\" memory.\n");
    } else com_err_set(&err_inf,"Unable to find \"NtCreateDebugObject\" in \"ntdll.dll\" memory.\n");
  } else com_err_set(&err_inf,"Unable to find \"ntdll.dll\" in memory.\n");

  return com_end(res,&err_inf,&conf);
}
