/*

 Security Software Testing Suite - Kill3d (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * A similar technique is used by Advanced Process Termination - Kill 2, 3 and 4, written by Diamond Computer Systems,
     http://www.diamondcs.com.au/.

   * A similar technique is also used by Simple Process Termination - Method 10 and 11, written by System Safety Limited.


 Method description:

   * The technique is almost the same as the technique described in "kill3.c".
     The only exception is that this test uses SendNotifyMessage function instead of SendMessage.


 Known issues and warnings:

   * After termination attempts, this test waits 5 seconds to give the target processes a chance to terminate.
     During this time no new process should be started, otherwise there is a chance to receive false negative results.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Kill3d","kill3d",argc,argv,&conf,COM_TEST_TYPE_KILL3D)) return 1;

  char *used_dlls[]={"user32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;


  ULONG pids[conf.processes_cnt];
  int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
  if (ret)
  {
    for (int i=0;i<conf.processes_cnt;i++)
    {
      if (pids[i]!=COM_CID_INVALID)
      {
        if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pids[i]);

        HWND windows[256];
        int windows_cnt=256;
        ret=com_get_process_windows(pids[i],windows,&windows_cnt,&err_inf);
        if (ret && (windows_cnt>0))
        {
          if (com_verbosity_get()) printf("%d window(s) that belong(s) to process \"%s\" (PID %ld) found.\n",windows_cnt,conf.processes[i],pids[i]);

          for (int j=0;j<windows_cnt;j++)
          {
            SendNotifyMessage(windows[j],WM_CLOSE,0,0);
            SendNotifyMessage(windows[j],WM_QUIT,0,0);
            SendNotifyMessage(windows[j],WM_SYSCOMMAND,SC_CLOSE,0);
          }
        } else
        {
          if (ret) fprintf(stderr,"ERROR: Process \"%s\" (PID %ld) has no windows and can not be terminated using this program.\n",
                           conf.processes[i],pids[i]);
          else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);
          pids[i]=COM_CID_INVALID;
        }

        if (com_verbosity_get()) printf("\n");
      } else if (ret) fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);

    }

    res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);
  }

  return com_end(res,&err_inf,&conf);
}
