/*

 Header file for Security for keylog7 test.
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#ifndef __KEYLOG7_H__
#define __KEYLOG7_H__

#ifdef __cplusplus
extern "C" {
#endif

#define DIRECTINPUT_VERSION 0x0700


// the test specific constant which determines whether a key is being pressed
#define KEY_DOWN KEY_DOWN_BYTE


HRESULT WINAPI DirectInputCreateEx(HINSTANCE hinst,DWORD dwVersion,REFIID riidltf,LPVOID *ppvOut,LPUNKNOWN punkOuter);


// Structure which is used to determine the right character for the character code obtainted from GetDeviceState method.
typedef struct KEY
{
  int code;          // the dinput code of the key
  char chr;          // the key character which is printed
} KEY,*PKEY;


// List of all printable keys we are interested in
KEY direct_input_character_map[]=
{
  { DIK_1, '1' },
  { DIK_2, '2' },
  { DIK_3, '3' },
  { DIK_4, '4' },
  { DIK_5, '5' },
  { DIK_6, '6' },
  { DIK_7, '7' },
  { DIK_8, '8' },
  { DIK_9, '9' },
  { DIK_0, '0' },
  { DIK_MINUS, '-' },
  { DIK_EQUALS, '=' },
  { DIK_TAB, '\t' },
  { DIK_Q, 'Q' },
  { DIK_W, 'W' },
  { DIK_E, 'E' },
  { DIK_R, 'R' },
  { DIK_T, 'T' },
  { DIK_Y, 'Y' },
  { DIK_U, 'U' },
  { DIK_I, 'I' },
  { DIK_O, 'O' },
  { DIK_P, 'P' },
  { DIK_LBRACKET, '[' },
  { DIK_RBRACKET, ']' },
  { DIK_RETURN, '\n' },
  { DIK_A, 'A' },
  { DIK_S, 'S' },
  { DIK_D, 'D' },
  { DIK_F, 'F' },
  { DIK_G, 'G' },
  { DIK_H, 'H' },
  { DIK_J, 'J' },
  { DIK_K, 'K' },
  { DIK_L, 'L' },
  { DIK_SEMICOLON, ';' },
  { DIK_APOSTROPHE, '\'' },
  { DIK_BACKSLASH, '\\' },
  { DIK_Z, 'Z' },
  { DIK_X, 'X' },
  { DIK_C, 'C' },
  { DIK_V, 'V' },
  { DIK_B, 'B' },
  { DIK_N, 'N' },
  { DIK_M, 'M' },
  { DIK_COMMA, ',' },
  { DIK_PERIOD, '.' },
  { DIK_SLASH, '/' },
  { DIK_MULTIPLY, '*' },
  { DIK_SPACE, ' ' },
};

#define direct_input_character_map_count ((int)(sizeof(direct_input_character_map)/sizeof(KEY)))


#ifdef __cplusplus
}
#endif

#endif
