/*

 Security Software Testing Suite - Kernel3 (General bypassing test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Using NtSetSystemInformation for driver loading was firstly described by Greg Hoglund.

   * A similar technique is used by Comodo HIPS and Firewall Leak Test Suite - Rootkit Installation 2,
     http://personalfirewall.comodo.com/cltinfo.html.


 Method description:

   * Load kernel driver using native function NtSetSystemInformation() class SystemLoadAndCallImage.

*/


#include <stdio.h>
#include <windows.h>
#include <ddk/ntapi.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "drv/drv.h"


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("Kernel3","kernel3",argc,argv,&conf,COM_TEST_TYPE_KERNEL3)) return 1;

  char *used_dlls[]={"ntdll.dll","advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  int res=FALSE;

  char cur_dir[MAX_PATH];
  if (com_get_module_path(NULL,cur_dir,sizeof(cur_dir),&err_inf))
  {
    if (com_privilege_enable(SE_LOAD_DRIVER_NAME,&err_inf))
    {
      char drv_bin2[MAX_PATH];
      snprintf(drv_bin2,sizeof(drv_bin2),"\\??\\%s\\drv2.sys",cur_dir);
      drv_bin2[sizeof(drv_bin2)-1]='\0';

      wchar_t drv_bin_w[MAX_PATH];
      snwprintf(drv_bin_w,sizeof(drv_bin_w)/sizeof(wchar_t),L"\\??\\%S\\drv.sys",cur_dir);
      drv_bin_w[sizeof(drv_bin_w)/sizeof(wchar_t)-1]=L'\0';

      HKEY hkey;
      LONG ret=RegCreateKeyEx(HKEY_LOCAL_MACHINE,"Software\\SSTS",0,NULL,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,NULL,&hkey,NULL);
      if (ret==ERROR_SUCCESS)
      {
        if (com_verbosity_get()) printf("Registry key \"HKLM\\Software\\SSTS\" created.\n");

        ret=RegSetValueEx(hkey,"drvbin",0,REG_EXPAND_SZ,drv_bin2,strlen(drv_bin2)+1);
        if (ret==ERROR_SUCCESS)
        {
          SYSTEM_LOAD_AND_CALL_IMAGE img;
          RtlInitUnicodeString(&img.ModuleName,drv_bin_w);

          NTSTATUS status=ZwSetSystemInformation(SystemLoadAndCallImage,&img,sizeof(img));
          if (status==STATUS_REQUEST_ABORTED)
          {
            if (com_verbosity_get()) printf("Driver loaded.\n");

            HANDLE device=CreateFile("\\\\.\\Global\\SSTSdrv",GENERIC_READ | GENERIC_WRITE,0,NULL,OPEN_EXISTING,0,NULL);
            if (device!=INVALID_HANDLE_VALUE)
            {
              DWORD bytes=0;
              if (DeviceIoControl(device,IOCTL_SSTS_PING,NULL,0,NULL,0,&bytes,NULL))
              {
                if (com_verbosity_get()) printf("Driver's state verified.\n");
                res=TRUE;

              } else com_err_set(&err_inf,"Failed to communicate with driver's device.\n");

              CloseHandle(device);
            } else com_err_set(&err_inf,"Unable to open driver's device.\n");

            UNICODE_STRING us;
            RtlInitUnicodeString(&us,L"\\REGISTRY\\MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SSTSdrv");
            ZwUnloadDriver(&us);
            RegDeleteKey(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SSTSdrv\\Enum");
            RegDeleteKey(HKEY_LOCAL_MACHINE,"SYSTEM\\CurrentControlSet\\Services\\SSTSdrv");
          } else com_err_set_nc(&err_inf,"Unable to load driver \"SSTSdrv\", error status 0x%lX.\n",status);
        } else com_err_set_sc(&err_inf,ret,"Unable to set value \"drvbin\" under \"HKLM\\Software\\SSTS\".\n");

        RegCloseKey(hkey);
        RegDeleteKey(HKEY_LOCAL_MACHINE,"Software\\SSTS");
      } else com_err_set_sc(&err_inf,ret,"Unable to create key \"HKLM\\Software\\SSTS\".\n");
    }
  }

  return com_end(res,&err_inf,&conf);
}
